// (c) 2004 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#ifndef CODEINESLIDER_H
#define CODEINESLIDER_H

#include <tqslider.h>

namespace Codeine
{
   class Slider : public TQSlider
   {
   Q_OBJECT

   public:
      static Slider *instance() { return s_instance; }

   public:
      Slider( TQWidget*, uint max = 0 );

      virtual void setValue( int );

   signals:
      //we emit this when the user has specifically changed the slider
      //so connect to it if valueChanged() is too generic
      //TQt also emits valueChanged( int )
      void sliderReleased( uint );

   protected:
      virtual void wheelEvent( TQWheelEvent* );
      virtual void mouseMoveEvent( TQMouseEvent* );
      virtual void mouseReleaseEvent( TQMouseEvent* );
      virtual void mousePressEvent( TQMouseEvent* );
      virtual void keyPressEvent( TQKeyEvent *e ) { e->ignore(); } //so that MainWindow gets the keypress

      virtual TQSize sizeHint() const { return TQSlider::sizeHint() + TQSize( 0, 6 ); }
      virtual TQSize minimumSizeHint() const { return sizeHint(); }

      bool m_sliding;

   private:
      static Slider *s_instance;

      bool m_outside;
      int  m_prevValue;

      Slider( const Slider& ); //undefined
      Slider &operator=( const Slider& ); //undefined
   };
}

#endif
