###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for tdeldap

find_library( HAVE_LIBTDELDAP tdeldap )
if( HAVE_LIBTDELDAP )
   set( LIBTDELDAP_LIBRARIES "tdeldap" )
  else()
   tde_message_fatal( "libtdeldap is required but was not found on your system" )
endif( )


##### check for krb5

pkg_search_module( KRB5 krb5 )
if( NOT KRB5_FOUND)
  if( NOT DEFINED KRB5_CONFIG_EXECUTABLE )
    find_program( KRB5_CONFIG_EXECUTABLE NAMES krb5-config )
    if( NOT KRB5_CONFIG_EXECUTABLE )
      tde_message_fatal( "krb5 library is required but was not found on your system" )
    endif( )
  endif( )

  execute_process(
    COMMAND ${KRB5_CONFIG_EXECUTABLE} --libs
    OUTPUT_VARIABLE KRB5_LIBRARIES
    ERROR_VARIABLE KRB5_LIBRARIES
    OUTPUT_STRIP_TRAILING_WHITESPACE
    ERROR_STRIP_TRAILING_WHITESPACE
  )
  execute_process(
    COMMAND ${KRB5_CONFIG_EXECUTABLE} --cflags
    OUTPUT_VARIABLE KRB5_INCLUDE_DIRS
    ERROR_VARIABLE KRB5_INCLUDE_DIRS
    OUTPUT_STRIP_TRAILING_WHITESPACE
    ERROR_STRIP_TRAILING_WHITESPACE
  )
  if( NOT "${KRB5_LIBRARIES}" STREQUAL "" )
    set( KRB5_FOUND 1 )
  endif( )
endif( )
