/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef NETWORKINTERFACE_H
#define NETWORKINTERFACE_H

#include <tqwidget.h>
#include <tqprocess.h>
#include <tqstringlist.h>
#include <tqobject.h>
#include <tqapplication.h>
#include <tdetempfile.h>
#include <tqhttp.h>
#include <tqstringlist.h>
#include "kvpncconfig.h"

/**
Class for interaction with network interface

@author Christoph Thielecke
*/
class NetworkInterface : public TQObject
{
	Q_OBJECT
  

public:
	/**
	 *     Konstruktor
	 * @param parent Pointer to parent widget
	 * @param name Name of the object
	 * @return nothing
	 */
	NetworkInterface( KVpncConfig* config,TQApplication *app, TQObject *parent = 0, const char *name = 0 );

	/**
	 *     Destruktor
	 * @return nothing
	 */
	~NetworkInterface();

	/**
	 *     Tests if the interface exists
	 * @param Interface The interface to test
	 * @return True if interface exist
	 */
	bool interfaceExist(TQString Interface);

	/**
	 *     Retrieves a list of all availiable interfaces
	 * @return List with all interfaces
	 */
	TQStringList getAllNetworkInterfaces();

	/**
	 *     Gets the IP from a given interface
	 * @param Interface The interface from which the IP whould be given
	 * @return The IP
	 */
	TQString getInterfaceIP(TQString Interface);

	TQString getInterfaceIP2(TQString Interface); // old style
	/**
	 *     Gets the device from a given IP
	 * @param IP The IP which the target interface has
	 * @return The interface where the IP is set
	 */
	TQString getInterfaceAddress(TQString IP);

	/**
	 *     Gets the interface where the default route points
	 * @return The interface
	 */
	TQString getDefaultInterface();

	/**
	 *     Gets the gateway of a given interface
	 * @return The interface
	 */
	TQString getGatewayOfInterface(TQString interface);

	TQString getNetmaskOfInterface(TQString interface);

	bool inSameNetwork(TQString ip1,TQString Netmask1,TQString ip2,TQString Netmask2);

	/**
	 *     Gets the gateway of the default route
	 * @return The interface
	 */
	TQString getGatewayOfDefaultInterface();

	/**
	*		Gets the count of default route entries
	* @return count
	*/
	int getDefaultRouteCount();

	/**
	 *    Gets the IP address which is used for communication with internet connections (same as local address if not behind router)
	 * @return The external IP address
	 */
	TQString  getExternalIpAddress();

	bool inSameNetwork(TQString ip1,TQString ip2);

public slots:
	void readFromStdout();
	void readFromStderr();
	void processHasFinished();
	void readFromStdout_interfaceip();
	void readFromStderr_interfaceip();
	void externalIpDataRecieved(const TQHttpResponseHeader & resp);

protected:
	TQProcess *proc; //< The process for starting external programs
	TQProcess *InterfaceExitsProc;
	TQProcess *InterfaceIpProc;
	bool interfaceTest; //< True if interface test is running
	bool retrieveInterfaceIP; //< True if retrieve interface IP is running
	bool retrieveInterfaceAddress; //< True if retrieve interface address is running
	TQStringList InterfaceList; //< List with interfaces
	TQString InterfaceIP; //< IP for interface
	TQString InterfaceAddress; //< Device for IP
	TQString GatewayAddress; //< Gateway of Device
	TQString GatewayOfInterfaceAddress;
	TQString GatewayOfDefaultInterfaceAddress; //< Gateway of Device
	bool interfaceExists; //< True if interface exists
	TQString ifconfigbin; //< Path to ifconfig
	TQString routebin; //< Path to route
	TQString defaultinterface; //< Interface with defaultroute
	TQString IPforInterface; //< The Ip for interface
	TQString tmpInterface; //< Interface for getting devname
	TQApplication *app;
	bool readOutput,getExternalIpAddressRunning;
	KTempFile *tmpfile;
	TQHttp *http;
	TQString ExternalIpAddress;
	TQStringList *env;
	KVpncConfig *GlobalConfig;
};

#endif
