/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

//BEGIN includes
#include <tqcheckbox.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <tqspinbox.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tdelocale.h>
#include "advancedsettingsdialog.h"
#include "toolinfo.h"
#include <iostream>
//END includes

AdvancedSettingsDialog::AdvancedSettingsDialog(TQWidget *parent, const TQString& caption, VpnAccountData *currentProfile, VpnAccountData::ConnectionType connectionType, KVpncConfig *GlobalConfig) : KDialogBase( parent, "Advanced_settings", true, caption, KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	main = new AdvancedProfileDialogBase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());

	this->currentProfile = currentProfile;
	this->connectionType = connectionType;

	connect (main->AdvancedSettingsCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(advancedSettingsToggled(bool)));
	connect (main->ApplicationVersionCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(applicationVersionToggled(bool)));
	connect (main->PerfectForwardSecurityCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(perfectForwardSecurityToggled(bool)));
	connect (main->IkeGroupCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(IkeGroupToggled(bool)));
	connect (main->SingleDesCheckbox, TQT_SIGNAL(toggled(bool)),this, TQT_SLOT(singleDesToggled(bool)));

	main->IkeGroupCheckbox->setEnabled( false );
	main->PerfectForwardSecrecyCombobox->setEnabled( false );
	main->SingleDesCheckbox->setEnabled( false );
	main->ApplicationVersionLineedit->setEnabled( false );
	main->PerfectForwardSecurityCheckbox->setEnabled( false );
	main->IkeGroupCombobox->setEnabled( false );
	main->ApplicationVersionCheckbox->setEnabled( false );
	main->IkeGroupCombobox->setEnabled( false );

	TQString vpnc_version="";
	ToolInfo *tool;
	for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
	{
		// 		std::cout << "tool: " << tool->Name << std::endl;
		// 		std::cout << "Version: " << tool->Version << std::endl;
		// 		std::cout << "Path: " << tool->PathToExec << std::endl << std::endl;
		if (tool->Name == "vpnc" )
		{
			vpnc_version=tool->Version;
			break;
		}
	}



	if (currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::cisco))
	{
		//main->PerfectForwardSecrecyCombobox->setEnabled( false );
		main->PerfectForwardSecrecyCombobox->clear();
		main->PerfectForwardSecrecyCombobox->insertItem( "server" );
		main->PerfectForwardSecrecyCombobox->insertItem( "nopfs" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh1" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh2" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh5");

		//main->IkeGroupCombobox->setEnabled( false );
		main->IkeGroupCombobox->clear();
		main->IkeGroupCombobox->insertItem( "dh1");
		main->IkeGroupCombobox->insertItem( "dh2");
		main->IkeGroupCombobox->insertItem( "dh5");
	}
	else if (currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon))
	{
		//main->PerfectForwardSecrecyCombobox->setEnabled( false );
		main->PerfectForwardSecrecyCombobox->clear();
		main->PerfectForwardSecrecyCombobox->insertItem( "dh1" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh2" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh5" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh14" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh15" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh16" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh17" );
		main->PerfectForwardSecrecyCombobox->insertItem( "dh18" );


		main->IkeGroupCheckbox->setEnabled( false );
		main->IkeGroupCombobox->clear();
		main->IkeGroupCombobox->insertItem( "dh1" );
		main->IkeGroupCombobox->insertItem( "dh2" );
		main->IkeGroupCombobox->insertItem( "dh5" );
		main->IkeGroupCombobox->insertItem( "dh1" );
		main->IkeGroupCombobox->insertItem( "dh2" );
		main->IkeGroupCombobox->insertItem( "dh5" );
		main->IkeGroupCombobox->insertItem( "dh14" );
		main->IkeGroupCombobox->insertItem( "dh15" );
		main->IkeGroupCombobox->insertItem( "dh16" );
		main->IkeGroupCombobox->insertItem( "dh17" );
		main->IkeGroupCombobox->insertItem( "dh18" );
	}

	main->ApplicationVersionLineedit->setText( "Cisco Systems VPN Client "+vpnc_version+":Linux" );

	main->AdvancedSettingsCheckbox->setChecked(currentProfile->getUseAdvancedSettings());
	this->advancedSettingsToggled(true);
}

AdvancedSettingsDialog::~AdvancedSettingsDialog()
{
	delete main;
}

void AdvancedSettingsDialog::advancedSettingsToggled(bool)
{
	main->IkeGroupCheckbox->setEnabled( false );
	main->PerfectForwardSecrecyCombobox->setEnabled( false );
	main->SingleDesCheckbox->setEnabled( false );
	main->ApplicationVersionLineedit->setEnabled( false );
	main->PerfectForwardSecurityCheckbox->setEnabled( false );
	main->IkeGroupCombobox->setEnabled( false );
	main->ApplicationVersionCheckbox->setEnabled( false );

	if ( this->main->AdvancedSettingsCheckbox->isChecked() )
	{
		main->groupBox3->setEnabled(true);
		if (connectionType == VpnAccountData::ConnectionType(VpnAccountData::cisco))
		{
			//if (currentProfile->getUseAdvancedSettings())
			//{
			main->SingleDesCheckbox->setEnabled( true );
			main->PerfectForwardSecurityCheckbox->setEnabled( true );
			main->ApplicationVersionCheckbox->setEnabled( true );
			main->PerfectForwardSecurityCheckbox->setEnabled ( true );
			main->IkeGroupCheckbox->setEnabled ( true );

		}
		else if (connectionType == VpnAccountData::ConnectionType(VpnAccountData::racoon))
		{

			//main->PerfectForwardSecrecyCombobox->setEnabled( false );
			main->SingleDesCheckbox->setEnabled( false );
			main->ApplicationVersionLineedit->setEnabled( false );
			main->PerfectForwardSecurityCheckbox->setEnabled( true );
			main->IkeGroupCombobox->setEnabled( false );
			main->ApplicationVersionCheckbox->setEnabled( false );
			main->IkeGroupCheckbox->setEnabled( true );
		}

	}

	else
	{
		main->groupBox3->setEnabled(false);
	}
}

void AdvancedSettingsDialog::applicationVersionToggled(bool)
{
	if ( main->ApplicationVersionCheckbox->isChecked() )
		main->ApplicationVersionLineedit->setEnabled( true );
	else
		main->ApplicationVersionLineedit->setEnabled( false );
}

void AdvancedSettingsDialog::IkeGroupToggled(bool)
{
	if ( main->IkeGroupCheckbox->isChecked() )
		main->IkeGroupCombobox->setEnabled( true );
	else
		main->IkeGroupCombobox->setEnabled( false );
}

void AdvancedSettingsDialog::perfectForwardSecurityToggled(bool)
{
	if ( main->PerfectForwardSecurityCheckbox->isChecked() )
		main->PerfectForwardSecrecyCombobox->setEnabled( true );
	else
		main->PerfectForwardSecrecyCombobox->setEnabled( false );
}

void AdvancedSettingsDialog::singleDesToggled(bool)
{}

void AdvancedSettingsDialog::helpClicked()
{}


void AdvancedSettingsDialog::accept()
{
	currentProfile->setUseAdvancedSettings( this->main->AdvancedSettingsCheckbox->isChecked() );
	currentProfile->setApplicationVersion( this->main->ApplicationVersionLineedit->text() );
	currentProfile->setUseApplicationVersion( this->main->ApplicationVersionCheckbox->isChecked() );
	currentProfile->setIkeGroup( this->main->IkeGroupCombobox->currentText() );
	currentProfile->setUseIkeGroup( this->main->IkeGroupCheckbox->isChecked() );
	currentProfile->setPerfectForwardSecrety( this->main->PerfectForwardSecrecyCombobox->currentText() );
	currentProfile->setUsePerfectForwardSecrety( this->main->PerfectForwardSecurityCheckbox->isChecked() );
	currentProfile->setUseSingleDes( this->main->SingleDesCheckbox->isChecked() );

	TQDialog::accept();
}

#include "advancedsettingsdialog.moc"
