//=============================================================================
//
//   File : optw_messages.cpp
//   Creation date : Sat Aug 11 2001 18:12:00 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define _WANT_OPTION_FLAGS_

#include "optw_messages.h"

#include <tqlayout.h>
#include <tqpushbutton.h>
#include "kvi_tal_vbox.h"
#include <tqcursor.h>
#include <tqpainter.h>
#include "kvi_styled_controls.h"

#include "kvi_settings.h"

#ifndef COMPILE_ON_WINDOWS
	#include <unistd.h> // symlink()
#endif

#include "kvi_options.h"
#include "kvi_app.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_mirccntrl.h"
#include "kvi_config.h"
#include "kvi_filedialog.h"

//#warning "Info tips"

#ifdef COMPILE_PSEUDO_TRANSPARENCY
	extern KVIRC_API TQPixmap * g_pShadedChildGlobalDesktopBackground;
#endif


KviMessageOptionsWidget::KviMessageOptionsWidget(TQWidget * pParent)
: KviOptionsWidget(pParent)
{
}

KviMessageOptionsWidget::~KviMessageOptionsWidget()
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

KviPrivmsgOptionsWidget::KviPrivmsgOptionsWidget(TQWidget * parent)
: KviOptionsWidget(parent,"privmsg_options_widget")
{
	createLayout(4,1);

	KviBoolSelector * b1;
	KviBoolSelector * b2;

	KviTalGroupBox * g = addGroupBox(0,0,0,0,1,Qt::Horizontal,__tr2qs_ctx("General","options"));
	
	addBoolSelector(g,__tr2qs_ctx("Show message icons","options"),KviOption_boolIrcViewShowImages);
	addBoolSelector(g,__tr2qs_ctx("Draw some emoticons (smileys) as pictures","options"),KviOption_boolDrawEmoticons);
	addBoolSelector(g,__tr2qs_ctx("Don't show colors in user messages","options"),KviOption_boolStripMircColorsInUserMessages);




	g = addGroupBox(0,1,0,1,1,Qt::Horizontal,__tr2qs_ctx("Nicknames","options"));

	b1 = addBoolSelector(g,__tr2qs_ctx("\"Smart\" nickname colors","options"),KviOption_boolColorNicks);
	b2 = addBoolSelector(g,__tr2qs_ctx("Use same colors as in the userlist","options"),KviOption_boolUseUserListColorsAsNickColors,!KVI_OPTION_BOOL(KviOption_boolColorNicks));
	connect(b1,TQT_SIGNAL(toggled(bool)),b2,TQT_SLOT(setNotEnabled(bool)));
	addBoolSelector(g,__tr2qs_ctx("Show nicknames in bold","options"),KviOption_boolBoldedNicks);
	addBoolSelector(g,__tr2qs_ctx("Show user and host","options"),KviOption_boolShowUserAndHostInPrivmsgView);
	addBoolSelector(g,__tr2qs_ctx("Show channel mode prefix","options"),KviOption_boolShowChannelUserFlagInPrivmsgView);
	KviBoolSelector * b = addBoolSelector(g,__tr2qs_ctx("User-defined prefix and postfix","options"),KviOption_boolUseExtendedPrivmsgView);

	TQLabel * l = addLabel(g,__tr2qs_ctx("[PREFIX]nickname[!user@host][POSTFIX] message","options"));

	l->setEnabled(KVI_OPTION_BOOL(KviOption_boolUseExtendedPrivmsgView));
	connect(b,
		TQT_SIGNAL(toggled(bool)),
		l,
		TQT_SLOT(setEnabled(bool)));

	KviTalVBox * vb = new KviTalVBox(g);
	vb->setSpacing(5);

	connect(
		b,
		TQT_SIGNAL(toggled(bool)),
		addStringSelector(vb,__tr2qs_ctx("Prefix:","options"),KviOption_stringExtendedPrivmsgPrefix,KVI_OPTION_BOOL(KviOption_boolUseExtendedPrivmsgView)),
		TQT_SLOT(setEnabled(bool)));
	connect(
		b,
		TQT_SIGNAL(toggled(bool)),
		addStringSelector(vb,__tr2qs_ctx("Postfix:","options"),KviOption_stringExtendedPrivmsgPostfix,KVI_OPTION_BOOL(KviOption_boolUseExtendedPrivmsgView)),
		TQT_SLOT(setEnabled(bool)));
	addRowSpacer(0,3,0,3);
}

KviPrivmsgOptionsWidget::~KviPrivmsgOptionsWidget()
{

}

KviTimestampOptionsWidget::KviTimestampOptionsWidget(TQWidget * pParent)
: KviOptionsWidget(pParent)
{
	createLayout(5,1);
	m_pUseTimestampSelector = addBoolSelector(0,0,0,0,__tr2qs_ctx("Show timestamp","options"),KviOption_boolIrcViewTimestamp);
	
	connect(m_pUseTimestampSelector,TQT_SIGNAL(toggled(bool)),this,TQT_SLOT(enableDisableTimestampSelector(bool)));
	KviBoolSelector* b = addBoolSelector(0,1,0,1,__tr2qs_ctx("Use UTC time for timestamp","options"),KviOption_boolIrcViewTimestampUTC,KVI_OPTION_BOOL(KviOption_boolIrcViewTimestamp));
	
	connect(m_pUseTimestampSelector,TQT_SIGNAL(toggled(bool)),b,TQT_SLOT(setEnabled(bool)));
	
	KviTalHBox *hb = new KviTalHBox(this);
	addWidgetToLayout(hb,0,2,0,2);
	
	m_pSpecialTimestampColorSelector = addBoolSelector(hb,__tr2qs_ctx("Use special color for timestamps","options"),KviOption_boolUseSpecialColorForTimestamp,KVI_OPTION_BOOL(KviOption_boolIrcViewTimestamp));
	connect(m_pSpecialTimestampColorSelector,TQT_SIGNAL(toggled(bool)),this,TQT_SLOT(enableDisableTimestampSelector(bool)));
	connect(m_pUseTimestampSelector,TQT_SIGNAL(toggled(bool)),m_pSpecialTimestampColorSelector,TQT_SLOT(setEnabled(bool)));
	
	m_pTimestampColorSelector = addMircTextColorSelector(hb,"",KviOption_uintTimeStampForeground,KviOption_uintTimeStampBackground,KVI_OPTION_BOOL(KviOption_boolIrcViewTimestamp) && KVI_OPTION_BOOL(KviOption_boolUseSpecialColorForTimestamp));

	KviStringSelector * st=addStringSelector(0,3,0,3,__tr2qs_ctx("Timestamp format:","options"),KviOption_stringIrcViewTimestampFormat);
	connect(m_pUseTimestampSelector,TQT_SIGNAL(toggled(bool)),st,TQT_SLOT(setEnabled(bool)));

	connect(m_pUseTimestampSelector,TQT_SIGNAL(toggled(bool)),m_pSpecialTimestampColorSelector,TQT_SLOT(setEnabled(bool)));
	addRowSpacer(0,4,0,4);
}

KviTimestampOptionsWidget::~KviTimestampOptionsWidget()
{
}

void KviTimestampOptionsWidget::enableDisableTimestampSelector(bool)
{
	m_pTimestampColorSelector->setEnabled(m_pUseTimestampSelector->isChecked() && m_pSpecialTimestampColorSelector->isChecked());
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

KviStandardColorsOptionsWidget::KviStandardColorsOptionsWidget(TQWidget * parent)
: KviOptionsWidget(parent,"stdcolors")
{
	createLayout(5,4);
	
	addColorSelector(0,0,0,0,"0:",&(KVI_OPTION_MIRCCOLOR(0)));
	addColorSelector(1,0,1,0,"1:",&(KVI_OPTION_MIRCCOLOR(1)));
	addColorSelector(2,0,2,0,"2:",&(KVI_OPTION_MIRCCOLOR(2)));
	addColorSelector(3,0,3,0,"3:",&(KVI_OPTION_MIRCCOLOR(3)));
	addColorSelector(0,1,0,1,"4:",&(KVI_OPTION_MIRCCOLOR(4)));
	addColorSelector(1,1,1,1,"5:",&(KVI_OPTION_MIRCCOLOR(5)));
	addColorSelector(2,1,2,1,"6:",&(KVI_OPTION_MIRCCOLOR(6)));
	addColorSelector(3,1,3,1,"7:",&(KVI_OPTION_MIRCCOLOR(7)));
	addColorSelector(0,2,0,2,"8:",&(KVI_OPTION_MIRCCOLOR(8)));
	addColorSelector(1,2,1,2,"9:",&(KVI_OPTION_MIRCCOLOR(9)));
	addColorSelector(2,2,2,2,"10:",&(KVI_OPTION_MIRCCOLOR(10)));
	addColorSelector(3,2,3,2,"11:",&(KVI_OPTION_MIRCCOLOR(11)));
	addColorSelector(0,3,0,3,"12:",&(KVI_OPTION_MIRCCOLOR(12)));
	addColorSelector(1,3,1,3,"13:",&(KVI_OPTION_MIRCCOLOR(13)));
	addColorSelector(2,3,2,3,"14:",&(KVI_OPTION_MIRCCOLOR(14)));
	addColorSelector(3,3,3,3,"15:",&(KVI_OPTION_MIRCCOLOR(15)));

	addRowSpacer(0,4,3,4);
	
	layout()->setRowStretch(4,1);
}

KviStandardColorsOptionsWidget::~KviStandardColorsOptionsWidget()
{
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


KviMessageListView::KviMessageListView(TQWidget * par)
: KviTalListView(par)
{
	setItemMargin(2);
}

KviMessageListView::~KviMessageListView()
{
}


void KviMessageListView::paintEmptyAreaInternal(TQPainter * p,const TQRect &viewportRect,const TQRect &painterRect)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedChildGlobalDesktopBackground)
	{
		TQPoint pnt = viewport()->mapToGlobal(viewportRect.topLeft());
		p->drawTiledPixmap(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),*g_pShadedChildGlobalDesktopBackground,pnt.x(),pnt.y());
	} else {
#endif
		TQPixmap * pix = KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap();
		if(pix)
		{
			TQPoint pnt = viewportToContents(viewportRect.topLeft());
			p->fillRect(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
			p->drawTiledPixmap(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),*pix,pnt.x(),pnt.y());
		} else {
			p->fillRect(painterRect.x(),painterRect.y(),painterRect.width(),painterRect.height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		}
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	}
#endif
}

void KviMessageListView::paintEmptyArea(TQPainter * p,const TQRect &rct)
{
	paintEmptyAreaInternal(p,rct,rct);
	KviTalListView::paintEmptyArea(p,rct);
}






KviMessageListViewItem::KviMessageListViewItem(KviTalListView * l,int optId)
: KviTalListViewItem(l)
{
	m_iOptId = optId;
	setText(0,"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
	m_pMsgType = new KviMsgType(KVI_OPTION_MSGTYPE(optId));
	setPixmap(0,*(g_pIconManager->getSmallIcon(0))); // just a dummy one to ensure that the size of the item is at least 20 pixels (16 + 2 * margin)
}

KviMessageListViewItem::~KviMessageListViewItem()
{
	delete m_pMsgType;
}

void KviMessageListViewItem::paintCell(TQPainter * p,const TQColorGroup &,int,int w,int)
{
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	if(g_pShadedChildGlobalDesktopBackground)
	{
		TQPoint pnt = listView()->viewport()->mapToGlobal(TQPoint(int(p->worldMatrix().dx()),int(p->worldMatrix().dy())));
		p->drawTiledPixmap(0,0,w,height(),*g_pShadedChildGlobalDesktopBackground,pnt.x(),pnt.y());
	} else {
#endif
		TQPixmap * pix = KVI_OPTION_PIXMAP(KviOption_pixmapIrcViewBackground).pixmap();
		if(pix)
		{
			TQPoint pnt = listView()->viewportToContents(TQPoint(int(p->worldMatrix().dx()),int(p->worldMatrix().dy())));
			p->fillRect(0,0,w,height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
			p->drawTiledPixmap(0,0,w,height(),*pix,pnt.x(),pnt.y());
		} else {
			p->fillRect(0,0,w,height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		}
#ifdef COMPILE_PSEUDO_TRANSPARENCY
	}
#endif


	p->drawPixmap(listView()->itemMargin(),(height() - 16) / 2,*(g_pIconManager->getSmallIcon(m_pMsgType->pixId())));
	// draw the background
	if(m_pMsgType->back() < 16)
	{
		TQColor bColor = KVI_OPTION_MIRCCOLOR(m_pMsgType->back());
		p->fillRect(22,listView()->itemMargin(),w - 24,height() - (listView()->itemMargin() * 2),bColor);
	}
	unsigned char ucFore = m_pMsgType->fore();
	if(ucFore > 15)ucFore = 0;
	p->setPen(TQPen(KVI_OPTION_MIRCCOLOR(ucFore)));
	// skip the msgtype prefix
	TQString txt = (g_msgtypeOptionsTable[m_iOptId].name + 7);
	txt += " (";
	txt += __tr2qs_no_xgettext(TQString::fromUtf8(m_pMsgType->type()));
	txt += ")";
	p->drawText(24,listView()->itemMargin(),w - 24,height() - (listView()->itemMargin() * 2),TQt::AlignLeft | TQt::AlignVCenter,txt);
	if(isSelected())
	{
#ifdef COMPILE_USE_QT4
		TQPen pen(KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		pen.setStyle(TQt::DashLine);
		p->setPen( pen);
		p->drawRect(0,0,w,height());
		p->drawRect(1,1,w - 2,height() - 2);
#else
	
		p->drawWinFocusRect(0,0,w,height(),KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
		p->drawWinFocusRect(1,1,w - 2,height() - 2,KVI_OPTION_COLOR(KviOption_colorIrcViewBackground));
#endif
	}
}


KviMessageColorListBoxItem::KviMessageColorListBoxItem(KviTalListBox * b,const TQColor &clr,int idx)
: KviTalListBoxText(b,TQString())
{
	m_clr = clr;
	m_iClrIdx = idx;
	if((idx < 0) || (idx > 15))setText(__tr2qs_ctx("Transparent","options"));
}

KviMessageColorListBoxItem::~KviMessageColorListBoxItem()
{
}

void KviMessageColorListBoxItem::paint(TQPainter * p)
{
	TQColor clr;

	const KviTalListBox * lb = (const KviTalListBox *)listBox();

	if((m_iClrIdx >= 0) && (m_iClrIdx <= 15))
	{
		clr = lb->isEnabled() ? KVI_OPTION_MIRCCOLOR(m_iClrIdx) : TQt::gray;
		p->fillRect(0,0,width(lb),height(lb),clr);
	} else {
		clr = listBox()->colorGroup().background();
		KviTalListBoxText::paint(p);
	}
	if(isSelected())
	{
#ifdef COMPILE_USE_QT4
	TQPen pen(clr);
	pen.setStyle(TQt::DashLine);
	p->setPen( pen);
	p->drawRect(0,0,width(lb),height(lb));
	p->drawRect(1,1,width(lb) - 2,height(lb) - 2);
	p->drawRect(2,2,width(lb) - 4,height(lb) - 4);
#else
	p->drawWinFocusRect(0,0,width(lb),height(lb),clr);
	p->drawWinFocusRect(1,1,width(lb) - 2,height(lb) - 2,clr);
	p->drawWinFocusRect(2,2,width(lb) - 4,height(lb) - 4,clr);
#endif
	}
}
/*
int KviMessageColorListBoxItem::width(const KviTalListBox * lb) const
{
	int w = lb->width();
	if(w < 30)w = 30;
	if(w > 150)w = 150;
	return w;
}

int KviMessageColorListBoxItem::height(const KviTalListBox *) const 
{
	return 30;
}
*/

/*
KviIrcColorsOptionsWidget::KviIrcColorsOptionsWidget(TQWidget * parent)
: KviOptionsWidget(parent,"irccolors","options")
{
	createLayout(5,4);

	addRowSpacer(0,4,3,4);
}

KviIrcColorsOptionsWidget::~KviIrcColorsOptionsWidget()
{
}
*/

KviMessageColorsOptionsWidget::KviMessageColorsOptionsWidget(TQWidget * parent)
: KviOptionsWidget(parent,"messages")
{
	int i;

	createLayout(2,4);

	m_pLastItem = 0;


	m_pListView = new KviMessageListView(this);
	m_pListView->addColumn(__tr2qs_ctx("Message Type","options"));
	m_pListView->setAllColumnsShowFocus(true);
	m_pListView->setSelectionMode(KviTalListView::Single);
	m_pListView->setFont(KVI_OPTION_FONT(KviOption_fontIrcView));
	m_pListView->setStaticBackground(true);
#ifdef COMPILE_USE_QT4
	m_pListView->viewport()->setBackgroundMode(TQt::NoBackground);
#else
	m_pListView->viewport()->setBackgroundMode(TQWidget::NoBackground);
#endif

	addWidgetToLayout(m_pListView,0,0,2,0);

	KviTalVBox * box = new KviTalVBox(this);
	addWidgetToLayout(box,3,0,3,0);

	TQLabel * l = new TQLabel(__tr2qs_ctx("Background:","options"),box);

	m_pBackListBox = new KviTalListBox(box);
	m_pBackItems[16] = new KviMessageColorListBoxItem(m_pBackListBox,TQt::gray,KVI_TRANSPARENT);
	for(i=0;i<16;i++)
	{
		m_pBackItems[i] = new KviMessageColorListBoxItem(m_pBackListBox,KVI_OPTION_MIRCCOLOR(i),i);
	}

	l = new TQLabel(__tr2qs_ctx("Foreground:","options"),box);

	m_pForeListBox = new KviTalListBox(box);
	for(i=0;i<16;i++)
	{
		m_pForeItems[i] = new KviMessageColorListBoxItem(m_pForeListBox,KVI_OPTION_MIRCCOLOR(i),i);
	}

	l = new TQLabel(__tr2qs_ctx("Alert level:","options"),box);

	m_pLevelListBox = new KviTalListBox(box);
	KviTalListBoxText * lbt;
	for(i=0;i<6;i++)
	{
		TQString tmpn;
		tmpn.setNum(i);
		lbt = new KviTalListBoxText(m_pLevelListBox,tmpn);
	}

	m_pIconButton = new KviStyledToolButton(box);
	connect(m_pIconButton,TQT_SIGNAL(clicked()),this,TQT_SLOT(iconButtonClicked()));

	m_pIconPopup = new KviTalPopupMenu(this);
	KviIconWidget * iw = new KviIconWidget(m_pIconPopup);
	connect(iw,TQT_SIGNAL(selected(int)),this,TQT_SLOT(newIconSelected(int)));
	m_pIconPopup->insertItem(iw);


	m_pEnableLogging = new KviStyledCheckBox(__tr2qs_ctx("Log this","options"),box);

	KviTalHBox * h = new KviTalHBox(this);
	addWidgetToLayout(h,0,1,3,1);
	TQPushButton * b = new TQPushButton(__tr2qs_ctx("Load From...","options"),h);
	connect(b,TQT_SIGNAL(clicked()),this,TQT_SLOT(load()));
	b = new TQPushButton(__tr2qs_ctx("Save As...","options"),h);
	connect(b,TQT_SIGNAL(clicked()),this,TQT_SLOT(save()));


	KviMessageListViewItem * it;

	for(i=0;i<KVI_NUM_MSGTYPE_OPTIONS;i++)
	{
		it = new KviMessageListViewItem(m_pListView,i);
	}

	layout()->setRowStretch(0,1);
	layout()->setColStretch(0,1);

	connect(m_pListView,TQT_SIGNAL(selectionChanged(KviTalListViewItem *)),this,TQT_SLOT(itemChanged(KviTalListViewItem *)));
	connect(m_pForeListBox,TQT_SIGNAL(selectionChanged(KviTalListBoxItem *)),this,TQT_SLOT(colorChanged(KviTalListBoxItem *)));
	connect(m_pBackListBox,TQT_SIGNAL(selectionChanged(KviTalListBoxItem *)),this,TQT_SLOT(colorChanged(KviTalListBoxItem *)));

	itemChanged(0);
}

KviMessageColorsOptionsWidget::~KviMessageColorsOptionsWidget()
{
}

void KviMessageColorsOptionsWidget::newIconSelected(int iconId)
{
	if(!m_pLastItem)return;
	if(iconId >= KVI_NUM_SMALL_ICONS)return;
	m_pLastItem->msgType()->setPixId(iconId);
	m_pIconButton->setIconSet(*(g_pIconManager->getSmallIcon(iconId)));
	m_pListView->repaintItem(m_pLastItem);
}

void KviMessageColorsOptionsWidget::saveLastItem()
{
	if(!m_pLastItem)return;

	int curIt = m_pForeListBox->currentItem();
	if(curIt != -1)
	{
		//tqDebug("Setting fore %d",curIt);
		KviMessageColorListBoxItem * fore = (KviMessageColorListBoxItem *)m_pForeListBox->item(curIt);
		//tqDebug("And is %d",fore);
		if(fore)m_pLastItem->msgType()->setFore(fore->m_iClrIdx);
	}
	curIt = m_pBackListBox->currentItem();
	if(curIt != -1)
	{
		KviMessageColorListBoxItem * back = (KviMessageColorListBoxItem *)m_pBackListBox->item(curIt);
		if(back)m_pLastItem->msgType()->setBack(back->m_iClrIdx);
	}
	m_pLastItem->msgType()->enableLogging(m_pEnableLogging->isChecked());
	//tqDebug("Updating","options");
	curIt = m_pLevelListBox->currentItem();
	if(curIt < 0 || curIt > 5)curIt = 1;
	m_pLastItem->msgType()->setLevel(curIt);
	m_pListView->repaintItem(m_pLastItem);
}

void KviMessageColorsOptionsWidget::itemChanged(KviTalListViewItem * it)
{
	//tqDebug("Item changed","options");
	if(m_pLastItem)saveLastItem();

	m_pLastItem = 0; // do NOT save in this routine

	m_pForeListBox->setEnabled(it);
	m_pBackListBox->setEnabled(it);
	m_pEnableLogging->setEnabled(it);
	m_pIconButton->setEnabled(it);
	m_pLevelListBox->setEnabled(it);

	if(it)
	{
		int back = ((KviMessageListViewItem *)it)->msgType()->back();
		int fore = ((KviMessageListViewItem *)it)->msgType()->fore();
		if(fore >= 0 && fore <= 15)
		{
			m_pForeListBox->setCurrentItem(m_pForeItems[fore]);
		}
		if(back >= 0 && back <= 15)
		{
			m_pBackListBox->setCurrentItem(m_pBackItems[back]);
		} else {
			m_pBackListBox->setCurrentItem(m_pBackItems[16]);
		}
		m_pLevelListBox->setCurrentItem(((KviMessageListViewItem *)it)->msgType()->level());
		m_pEnableLogging->setChecked(((KviMessageListViewItem *)it)->msgType()->logEnabled());
		m_pIconButton->setIconSet(*(g_pIconManager->getSmallIcon(((KviMessageListViewItem *)it)->msgType()->pixId())));
	}

	// Ok...can save from now on
	m_pLastItem = (KviMessageListViewItem *)it;

}

void KviMessageColorsOptionsWidget::colorChanged(KviTalListBoxItem *)
{
	if(m_pLastItem)saveLastItem();
}

void KviMessageColorsOptionsWidget::iconButtonClicked()
{
	m_pIconPopup->popup(TQCursor::pos());
}

void KviMessageColorsOptionsWidget::commit()
{
	saveLastItem();

	mergeResetFlag(KviOption_resetUpdateGui);

	KviMessageListViewItem * it = (KviMessageListViewItem *)m_pListView->firstChild();
	while(it)
	{
		KVI_OPTION_MSGTYPE(it->optionId()) = *(it->msgType());
		it = (KviMessageListViewItem *)(it->nextSibling());
	}

	KviOptionsWidget::commit();
}

void KviMessageColorsOptionsWidget::save()
{
	TQString szName;
	TQString szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::MsgColors);

	if(KviFileDialog::askForSaveFileName(szName,__tr2qs_ctx("Choose a Filename - KVIrc","options"),szInit))
	{
		if(m_pLastItem)saveLastItem();

		KviConfig cfg(szName,KviConfig::Write);

		cfg.setGroup("Messages");

		KviStr tmp;

	
		KviMessageListViewItem * it = (KviMessageListViewItem *)m_pListView->firstChild();

		while(it)
		{
			tmp.sprintf("Fore%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->fore());
			tmp.sprintf("Back%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->back());
			tmp.sprintf("Icon%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->pixId());
			tmp.sprintf("Log%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->logEnabled());
			tmp.sprintf("Level%d",it->optionId());
			cfg.writeEntry(tmp.ptr(),it->msgType()->level());
			it = (KviMessageListViewItem *)(it->nextSibling());
		}

	}
}

//#include <errno.h>

void KviMessageColorsOptionsWidget::load()
{

	//KviStr szName;
	TQString szName;
	//KviStr szInit;
	TQString szInit;
	g_pApp->getLocalKvircDirectory(szInit,KviApp::MsgColors);

#ifndef COMPILE_ON_WINDOWS
	// symlink local to global
	//KviStr szGlobal;
	TQString szGlobal;
	g_pApp->getGlobalKvircDirectory(szGlobal,KviApp::MsgColors);
	//KviStr szLocal;
	TQString szLocal;
	g_pApp->getLocalKvircDirectory(szLocal,KviApp::MsgColors,"presets");
	//tqDebug("SYMLINKING %s to %s",szGlobal.ptr(),szLocal.ptr());
	//tqDebug("SYMLINK RETURNS %d (%d)",::symlink(szGlobal.ptr(),szLocal.ptr()));
	//tqDebug("ERRNO (%d)",errno);
	symlink(szGlobal,szLocal);
	// FIXME: Do it also on windows...
#endif

	if(KviFileDialog::askForOpenFileName(szName,__tr2qs_ctx("Choose a Filename - KVIrc ","options"),szInit))
	{

		itemChanged(0);
		

		KviConfig cfg(szName,KviConfig::Read);

		cfg.setGroup("Messages");

		//KviStr tmp;
		TQString tmp;
		KviMessageListViewItem * it = (KviMessageListViewItem *)m_pListView->firstChild();

		while(it)
		{
			tmp.sprintf("Fore%d",it->optionId());
			int fore = cfg.readIntEntry(tmp,it->msgType()->fore());
			if(fore < 0 || fore > 15)fore = 0;
			it->msgType()->setFore(fore);

			tmp.sprintf("Back%d",it->optionId());
			int back = cfg.readIntEntry(tmp,it->msgType()->back());
			if(back < 0 || back > 15)back = KVI_TRANSPARENT;
			it->msgType()->setBack(back);

			tmp.sprintf("Icon%d",it->optionId());
			int ico = cfg.readIntEntry(tmp,it->msgType()->pixId());
			if(ico < 0 || ico >= KVI_NUM_SMALL_ICONS)ico = 0;
			it->msgType()->setPixId(ico);

			tmp.sprintf("Log%d",it->optionId());
			bool bLog = cfg.readBoolEntry(tmp,it->msgType()->logEnabled());
			it->msgType()->enableLogging(bLog);

			tmp.sprintf("Level%d",it->optionId());
			int iLevel = cfg.readIntEntry(tmp,it->msgType()->level());
			it->msgType()->setLevel(iLevel);

			m_pListView->repaintItem(it);

			it = (KviMessageListViewItem *)(it->nextSibling());
		}

	}
}

#include "m_optw_messages.moc"
