/***************************************************************************
                          serverdialog.h  -  description
                             -------------------
    begin                : Sun Oct 28 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SERVERDIALOG_H
#define SERVERDIALOG_H

//TQt headers
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqtooltip.h>
#include <tqspinbox.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>

//KDE headers
#include <kdialogbase.h>
#include <tdelocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <tdemessagebox.h>
#include <kpassdlg.h>

//KShowmail headers
#include "configelem.h"
#include "constants.h"
#include "encryption.h"
#include "tdewalletaccess.h"
#include <ktabwidget.h>

//radio button IDs
#define ID_BUTTON_PASSWORD_DONT_SAVE 1
#define ID_BUTTON_PASSWORD_SAVE_FILE 2
#define ID_BUTTON_PASSWORD_SAVE_TDEWALLET 3
#define ID_BUTTON_SECLOGIN_NONE 1
#define ID_BUTTON_SECLOGIN_APOP 2
#define ID_BUTTON_SECLOGIN_SASL 3
#define ID_BUTTON_SECTRANSFER_NONE 1
#define ID_BUTTON_SECTRANSFER_SSL 2
#define ID_BUTTON_SECTRANSFER_TLS 3

/**
 * @brief Dialog to edit account options. You can not create a new account or edit the account name.
 * @author Eggert Ehmke
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */

class ServerDialog : public KDialogBase
{
   Q_OBJECT
  public:

  public:

    /**
     * General constructor
     * @param parent parent of the dialog
     * @param item account to setup
     */
    ServerDialog( TQWidget* parent, ConfigElem* item = NULL );

    /**
     * Destructor
     */
    ~ServerDialog();

  private:

    /**
     * account to setup
     */
    ConfigElem* account;

    /**
     * Edit line which contains the unique account name.
     */
    KLineEdit* txtAccount;

    /**
     * Edit line which contains the server name.
     */
    KLineEdit* txtServer;

    /**
     * Combo box to choose the protocol.
     */
    KComboBox* cboProtocol;

    /**
     * Spinbox to choose the tcp port.
     */
    TQSpinBox* spbPort;

    /**
     * Edit line which contains the user name.
     */
    KLineEdit* txtUser;

    /**
     * Edit line which contains the password.
     */
    KPasswordEdit* txtPassword;

    /**
     * Check box to select whether the account is active or not.
     */
    TQCheckBox* chkActive;

    /**
     * Combines the radio buttons of password storage.
     */
    TQButtonGroup* grpPasswordStorage;

    /**
     * Combines the radio buttons of secure transfer.
     */
    TQButtonGroup* grpSecureTransfer;

  protected slots:

    /**
   * Connected with the password button group.
   * Enabled or disabled the password edit line.
   * @param id button identifier
     */
    void slotPasswordStorageChanged( int id );

    /**
     * Connected with the secure transfer button group.
     * Changes the port number.
     * @param id button identifier
     */
    void slotSecureTransferChanged( int id );

    /**
     * Overwritten methode of KDialogBase.
     * Called if OK was clicked.
     * Stores the entered values into the given account item.
     * If no item was given, it creates a new one.
     * After then it invokes slotOk() of KDialogBase.
     */
    void slotOk();

  protected:

    /**
   * Writes the values of the account into the dialog items.
     */
    void fillDialog();
};

#endif
