/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2005 Ismail Donmez <ismail@kde.org>
  Copyright (C) 2005 Peter Simonsson <psn@linux.se>
  Copyright (C) 2005 John Tapsell <johnflux@gmail.com>
  Copyright (C) 2005-2008 Eike Hein <hein@kde.org>
*/

#ifndef OUTPUTFILTER_H
#define OUTPUTFILTER_H

#include "identity.h"
#include "common.h"

#include <tqobject.h>
#include <tqstring.h>
#include <kurl.h>
#include <tdeio/global.h>


class Server;
class ChatWindow;

namespace Konversation
{
    enum MessageType
    {
        Message,
        Action,
        Command,
        Program,
        PrivateMessage
    };

    struct OutputFilterResult
    {
        TQString output;
        TQStringList outputList;
        TQString toServer;
        TQStringList toServerList;
        TQString typeString;
        MessageType type;
    };

    class OutputFilter : public TQObject
    {
        Q_OBJECT
  

        public:
            explicit OutputFilter(Server* server);
            ~OutputFilter();

            TQStringList splitForEncoding(const TQString& inputLine, uint max);
            OutputFilterResult parse(const TQString& myNick,const TQString& line,const TQString& name);

            // dcc send
            OutputFilterResult sendRequest(const TQString &recipient,const TQString &fileName,const TQString &address,const TQString &port,unsigned long size);
            OutputFilterResult passiveSendRequest(const TQString& recipient,const TQString &fileName,const TQString &address,unsigned long size,const TQString &token);
            OutputFilterResult acceptResumeRequest(const TQString &recipient,const TQString &fileName,const TQString &port,int startAt);

            // dcc recv
            OutputFilterResult resumeRequest(const TQString &sender,const TQString &fileName,const TQString &port,TDEIO::filesize_t startAt);
            OutputFilterResult acceptPassiveSendRequest(const TQString& recipient,const TQString &fileName,const TQString &address,const TQString &port,unsigned long size,const TQString &token);

            bool replaceAliases(TQString& line);

        signals:
            void openDccSend(const TQString &recipient, KURL kurl);
            void requestDccSend();                // Choose Recipient and File from requester
                                                  // Choose File from requester
            void requestDccSend(const TQString& recipient);
            void openDccChat(const TQString& nick);
            void addDccPanel();
            void closeDccPanel();
            void openRawLog(bool show);
            void closeRawLog();
            void openKonsolePanel();
            void openChannelList(const TQString& parameter, bool getList);
            void sendToAllChannels(const TQString& text);
            void launchScript(const TQString& target, const TQString& parameter);
            void banUsers(const TQStringList& userList,const TQString& channel,const TQString& option);
            void unbanUsers(const TQString& mask,const TQString& channel);
            void multiServerCommand(const TQString& command, const TQString& parameter);
            void reconnectServer();
            void disconnectServer();

            void connectTo(Konversation::ConnectionFlag flag,
                           const TQString& hostName,
                           const TQString& port = "",
                           const TQString& password = "",
                           const TQString& nick = "",
                           const TQString& channel = "",
                           bool useSSL = false
            );

            void showView(ChatWindow* view);
            void encodingChanged ();


        public slots:
            void setCommandChar();
            OutputFilterResult execBan(const TQString& mask,const TQString& channels);
            OutputFilterResult execUnban(const TQString& mask,const TQString& channels);

        protected:
            OutputFilterResult parseMsg(const TQString& myNick,const TQString& parameter, bool focusQueryWindow);
            OutputFilterResult parseSMsg(const TQString& parameter);
            OutputFilterResult parseMe(const TQString &parameter, const TQString &destination);
            OutputFilterResult parseDescribe(const TQString& parameter);
            OutputFilterResult parseNotice(const TQString& parameter);
            OutputFilterResult parseJoin(TQString& parameter);
            OutputFilterResult parsePart(const TQString& parameter);
            OutputFilterResult parseQuit(const TQString& parameter);
            OutputFilterResult parseClose(TQString parameter);
            OutputFilterResult parseKick(const TQString& parameter);
            OutputFilterResult parseKickBan(const TQString& parameter);
            OutputFilterResult parseBan(const TQString& parameter, bool kick = false);
            OutputFilterResult parseUnban(const TQString& parameter);
            OutputFilterResult parseNames(const TQString& parameter);
            OutputFilterResult parseList(const TQString& parameter);
            OutputFilterResult parseOp(const TQString& parameter);
            OutputFilterResult parseDeop(const TQString& ownNick, const TQString& parameter);
            OutputFilterResult parseHop(const TQString& parameter);
            OutputFilterResult parseDehop(const TQString& ownNick, const TQString& parameter);
            OutputFilterResult parseVoice(const TQString& parameter);
            OutputFilterResult parseUnvoice(const TQString& ownNick, const TQString& parameter);
            OutputFilterResult parseTopic(const TQString& parameter);
            void parseAway(TQString& parameter);
            void parseBack();
            OutputFilterResult parseCtcp(const TQString& parameter);
            OutputFilterResult parsePing(const TQString& parameter);
            OutputFilterResult parseVersion(const TQString& parameter);
            void parseServer(const TQString& parameter);
            void parseReconnect();
            OutputFilterResult parseConnect(const TQString& parameter);
            OutputFilterResult parseInvite(const TQString& parameter);
            OutputFilterResult parseExec(const TQString& parameter);
            OutputFilterResult parseNotify(const TQString& parameter);
            OutputFilterResult parseOper(const TQString& myNick,const TQString& parameter);
            OutputFilterResult parseDcc(const TQString& parameter);
            OutputFilterResult parseRaw(const TQString& parameter);
            OutputFilterResult parseIgnore(const TQString& parameter);
            OutputFilterResult parseUnignore(const TQString& parameter);
            OutputFilterResult parseQuote(const TQString& parameter);
            OutputFilterResult parseSay(const TQString& parameter);
            void parseKonsole();
            OutputFilterResult parseAme(const TQString& parameter);
            OutputFilterResult parseAmsg(const TQString& parameter);
            OutputFilterResult parseOmsg(const TQString& parameter);
            OutputFilterResult parseOnotice(const TQString& parameter);
            OutputFilterResult parseCharset(const TQString& charset);
            void parseCycle();
            OutputFilterResult parseSetKey(const TQString& parameter);
            OutputFilterResult parseDelKey(const TQString& parameter);
            OutputFilterResult parseShowKey(const TQString& parameter);
            OutputFilterResult parseDNS(const TQString& parameter);
            OutputFilterResult parseKill(const TQString& parameter);
            OutputFilterResult parseShowTuner(const TQString &p);

            OutputFilterResult changeMode(const TQString& parameter,char mode,char giveTake);
            bool isAChannel(const TQString& check);
            OutputFilterResult usage(const TQString& check);
            OutputFilterResult info(const TQString& check);
            OutputFilterResult error(const TQString& check);

            TQString addNickToEmptyNickList(const TQString& nick, const TQString& parameter);

        private:
            TQString destination;
            TQString commandChar;

            Server* m_server;
    };
}
#endif
