/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef _GETPROFILEDIALOG_H_
#define _GETPROFILEDIALOG_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <kdialogbase.h>
#include "global.h"

//	forward class definitions
//	=========================

class TDEConfig;
class TQLineEdit;
class TQListBox;
class TQListBoxItem;
class TQString;

//	ProfileDialog class definition
//	==============================

class ProfileDialog : public KDialogBase
{	Q_OBJECT

	public:
		enum Action
		{	Copy,
			Delete,
			Load,
			Rename,
			SaveAs
		};

		ProfileDialog( Action         action,
					   const TQString& currentProfile,
					   TQWidget*       parent = NULL,
					   const char*    name = NULL );

		TQString profileName( ) const { return m_profileName; }

	private slots:
		void slotOk( );
		void slotCopy( );
		void slotDelete( );
		void slotProfileListBoxChanged( );
		void slotProfileListContextMenu( TQListBoxItem* item, const TQPoint& pos );
		void slotRename( );

	private:
		bool    checkForDuplicateName( const TQString& profileName );
		TQString constructNewProfileName( const TQString& initialProfileName ) const;
		void    copy( const TQString& fromProfileName, const TQString& toProfileName );
		void    createlayout( );
		void    deelete( const TQString& profileName, const bool ask );
		void    deelete( TQListBoxItem* item, const bool ask );
		bool    getNewProfileName( TQString& profileName );
		void    setInitialValues( const TQString& currentProfile );
		TQString stripPrefix( const TQString& profileName ) const;

		Action        m_action;
		TQListBoxItem* m_contextItem;
		TQString       m_profileName;
		TQLineEdit*    m_profileLineEdit;
		TQListBox*     m_profileListBox;
};

#endif	//	_GETPROFILEDIALOG_H_
