/***************************************************************************
                          dlg_server.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_SERVER_H
#define DLG_SERVER_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <tdefiledialog.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqcheckbox.h>
#include <tqstring.h>
#include "definitions.h"
#include "resource.h"

/**
  *@author Troy Corbin Jr.
  */

class dlg_server : public KDialogBase
{
   Q_OBJECT
  
	public:
													dlg_server(TQWidget *parent=0, const char *name=0, resource *Rsrc=0, TQString ItemName="" );
													~dlg_server();

	public slots:
		void									slotOk( void );
		void									slotApply( void );
		void									slotCancel( void );
		void									slotLogFileDialog( void );
		void									slotEnableApply( const TQString& );
		void									slotStorePass( bool state );
		void									slot_Timeseal( void );

	private:
		serverList::Iterator	serversIT;
		resource							*Resource;
		TQString								Name;

		TQVBox									*BOX_Parent;
		TQHBox									*BOX_URLPort;
		TQHBox									*BOX_UNameStore;
		TQHBox									*BOX_Pass;

		TQGroupBox							*BOX_Name;
		KLineEdit							*EDIT_Name;

		TQGroupBox							*BOX_URL;
		KLineEdit							*EDIT_URL;
		
		TQGroupBox							*BOX_Port;
		KLineEdit							*EDIT_Port;
		
		TQGroupBox							*BOX_UserName;
		KLineEdit							*EDIT_UserName;
		TQCheckBox							*CHECK_StorePass;

		TQGroupBox							*BOX_Password;
		KLineEdit							*EDIT_Password;
		
		TQGroupBox							*BOX_PasswordRetype;
		KLineEdit							*EDIT_PasswordRetype;

		TQGroupBox							*GROUP_Timeseal;
			KLineEdit							*EDIT_Timeseal;
				TQPushButton					*BUTTON_Timeseal;
		
		TQGroupBox							*BOX_LogFile;
		KLineEdit							*EDIT_LogFile;
		TQPushButton						*BUTTON_LogFile;
};

#endif
