/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef GPUTILS_COMPILE_H
#define GPUTILS_COMPILE_H

#include "tools/list/compile_process.h"

namespace GPUtils
{
//-----------------------------------------------------------------------------
class Process : public Compile::Process
{
Q_OBJECT
  
private:
  virtual TQString deviceName() const;
  virtual bool hasLinkerScript() const { return ( _data.linkType==Compile::Icd2Linking || Compile::Process::hasLinkerScript() ); }
};

//-----------------------------------------------------------------------------
class AssembleFile : public Process
{
Q_OBJECT
  
private:
  virtual void logStderrLine(const TQString &line);
};

//-----------------------------------------------------------------------------
class AssembleStandaloneFile : public AssembleFile
{
Q_OBJECT
  
private:
  virtual TQString outputFiles() const;
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class AssembleProjectFile : public AssembleFile
{
Q_OBJECT
  
private:
  virtual TQString outputFiles() const;
  virtual TQStringList genericArguments(const Compile::Config &config) const;
};

//-----------------------------------------------------------------------------
class LinkProject : public Process
{
Q_OBJECT
  
private:
  virtual TQString outputFiles() const;
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual void logStderrLine(const TQString &line) { doLog(filterType(line), line, TQString(), 0); }
};

//-----------------------------------------------------------------------------
class LibraryProject : public Process
{
Q_OBJECT
  
private:
  virtual TQString outputFiles() const;
  virtual TQStringList genericArguments(const Compile::Config &config) const;
  virtual void logStderrLine(const TQString &line) { doLog(filterType(line), line, TQString(), 0); }
};

} // namespace

#endif
