/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *   Copyright (C) 2003-2004 Alain Gibaud <alain.gibaud@free.fr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "hex_word_editor.h"

#include <tqframe.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqapplication.h>
#include <tqtimer.h>

//-----------------------------------------------------------------------------
Device::HexWordEditor::HexWordEditor(Memory &memory, uint nbChars, TQWidget *parent)
  : GenericHexWordEditor(nbChars, true, parent), _memory(memory)
{
  setOffset(-1);
}

void Device::HexWordEditor::setOffset(int offset)
{
  _offset = offset;
  set();
}

//-----------------------------------------------------------------------------
Device::RegisterHexWordEditor::RegisterHexWordEditor(TQWidget *parent, uint nbChars, BitValue mask)
  : GenericHexWordEditor(nbChars, true, parent), _mask(mask)
{
  clear();
}

void Device::RegisterHexWordEditor::setValue(BitValue word)
{
  _word = word;
  set();
}
