/***************************************************************************
 *   Copyright (C) 2005 by Mark Six                                        *
 *   marksix@xs4all.nl                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KEXPORTDIALOG_H
#define KEXPORTDIALOG_H

#include <tqobject.h>
#include <klineedit.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqstring.h>
#include <tqdialog.h>

class KExportDialog : public TQDialog
{
	Q_OBJECT
  
	public:
    	KExportDialog(TQWidget *parent = 0, const char *name = 0 );
    	~KExportDialog();
	
		void setOutputDir( TQString dir ) ;
		void setTemplateFile( TQString file ) ;
		void setEntityName( TQString name ) ;
		
		TQString getTemplateFile() ;
		TQString getOutputDir() ;
		TQString getEntityName() ;
		
		void modal() ;
		
		bool isCanceled() { return m_bCanceled ; } 
	protected:
		TQString m_outputDir ;
		TQString m_templateFile ;
		TQString m_entityName ;
		
		KLineEdit * m_lineTemplateFile, * m_lineOutputDir, *m_lineEntityName ;
		bool m_bCanceled ;
		
	public slots:
		void btnOKClicked() ;
		void btnCancelClicked() ;
		void showFileDialog() ;
		void showDirDialog() ;
};

#endif
