/* standalone.cpp
**
** Copyright (C) 2000,2001 by Bernhard Rosenkraenzer
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include <tqapplication.h>
#include <tqobject.h>
#include <tqwhatsthis.h>
#include <tqwindowsstyle.h>
#include <mainwidget.h>
#include <ui.h>
#include "standalone.moc"

Standalone::Standalone(TQWidget *parent, const char *name):TQWidget(parent,name)
{
	m=new MainWidget(this);
	connect(m, TQT_SIGNAL(configChanged()), TQT_SLOT(configChanged()));
	actions=new TQHButtonGroup(this);
	_whatsthis=new TQPushButton(_("&What's This?"), actions);
	_whatsthis->setAccel(SHIFT+Key_F1);
	TQWhatsThis::add(_whatsthis, _("The <i>What's This?</i> button is part of this program's help system. Click on the What's This? button then on any widget in the window to get information (like this) on it."));
	connect(_whatsthis, TQT_SIGNAL(clicked()), TQT_SLOT(whatsthis()));
	_help=new TQPushButton(_("&Help"), actions);
	_help->setAccel(Key_F1);
	TQWhatsThis::add(_help, _("This button calls up the program's online help system. If it does nothing, no help file has been written (yet); in that case, use the <i>What's This</i> button on the left."));
	connect(_help, TQT_SIGNAL(clicked()), this, TQT_SLOT(help()));
	_deflt=new TQPushButton(_("&Default"), actions);
	TQWhatsThis::add(_deflt, _("This button resets all parameters to some (hopefully sane) default values."));	
	connect(_deflt, TQT_SIGNAL(clicked()), this, TQT_SLOT(defaults()));
	_reset=new TQPushButton(_("&Reset"), actions);
	TQWhatsThis::add(_reset, _("This button resets all parameters to what they were before you started the program."));
	connect(_reset, TQT_SIGNAL(clicked()), this, TQT_SLOT(reset()));
	_apply=new TQPushButton(_("&Apply"), actions);
	TQWhatsThis::add(_apply, _("This button saves all your changes without exiting."));
	connect(_apply, TQT_SIGNAL(clicked()), this, TQT_SLOT(apply()));
	_ok=new TQPushButton(_("&OK"), actions);
	TQWhatsThis::add(_ok, _("This button saves all your changes and exits the program."));
	connect(_ok, TQT_SIGNAL(clicked()), this, TQT_SLOT(ok()));
	_cancel=new TQPushButton(_("&Cancel"), actions);
	TQWhatsThis::add(_cancel, _("This button exits the program without saving your changes."));
	connect(_cancel, TQT_SIGNAL(clicked()), this, TQT_SLOT(cancel()));
	_apply->setEnabled(false);
	setMinimumWidth(actions->sizeHint().width()+10);
	arrangeWidgets();
}

void Standalone::arrangeWidgets()
{
	m->setGeometry(SPACE_MARGIN, SPACE_MARGIN, width()-2*SPACE_MARGIN, height()-actions->sizeHint().height()-SPACE_MARGIN-SPACE_INSIDE);
	actions->setGeometry(SPACE_MARGIN, height()-actions->sizeHint().height()-SPACE_MARGIN, width()-2*SPACE_MARGIN, actions->sizeHint().height());
}

void Standalone::resizeEvent(TQResizeEvent *e)
{
	TQWidget::resizeEvent(e);
	arrangeWidgets();
}

void Standalone::whatsthis()
{
	TQWhatsThis::enterWhatsThisMode();
}
void Standalone::help()
{
}
void Standalone::defaults()
{
	m->defaults();
}
void Standalone::reset()
{
	m->reset();
}
void Standalone::apply()
{
	m->save();
}
void Standalone::ok()
{
	m->save();
	emit done();
}
void Standalone::cancel()
{
	emit done();
}

void Standalone::configChanged() // SLOT
{
	_apply->setEnabled(true);
}

int main(int argc, char **argv) {
	TQApplication a(argc, argv);
	Standalone *s=new Standalone(0);
	int ret;
	a.setStyle(new TQWindowsStyle());
	a.setMainWidget(s);
	TQObject::connect(s, TQT_SIGNAL(done()), &a, TQT_SLOT(quit()));
	s->show();
	ret=a.exec();
	delete s;
	return ret;
}
