/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMRAINBOWEDIT_H
#define PMRAINBOWEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebaseedit.h"

class PMRainbow;
class PMFloatEdit;
class PMVectorEdit;
class TQCheckBox;
class TQLabel;

/**
 * Dialog edit class for @ref PMRainbow
 */
class PMRainbowEdit : public PMTextureBaseEdit
{
   Q_OBJECT
  
   typedef PMTextureBaseEdit Base;
public:
   /**
    * Creates a PMRainbowEdit with parent and name
    */
   PMRainbowEdit( TQWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );
protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

protected slots:
   void slotDirectionClicked( );
   void slotAngleClicked( );
   void slotWidthClicked( );
   void slotDistanceClicked( );
   void slotJitterClicked( );
   void slotUpClicked( );
   void slotArcAngleClicked( );
   void slotFalloffAngleClicked( );

private:
   PMRainbow* m_pDisplayedObject;
   PMVectorEdit* m_pDirectionEdit; 
   PMFloatEdit* m_pAngleEdit;
   PMFloatEdit* m_pWidthEdit;
   PMFloatEdit* m_pDistanceEdit;
   PMFloatEdit* m_pJitterEdit;
   PMVectorEdit* m_pUpEdit;
   PMFloatEdit* m_pArcAngleEdit;
   PMFloatEdit* m_pFalloffAngleEdit;
   TQCheckBox* m_pEnableDirectionEdit;
   TQCheckBox* m_pEnableAngleEdit;
   TQCheckBox* m_pEnableWidthEdit;
   TQCheckBox* m_pEnableDistanceEdit;
   TQCheckBox* m_pEnableJitterEdit;
   TQCheckBox* m_pEnableUpEdit;
   TQCheckBox* m_pEnableArcAngleEdit;
   TQCheckBox* m_pEnableFalloffAngleEdit;
};


#endif
