/**
   File : xsldbginspector.h
   Author : Keith Isdale
   Date : 30th March 2002
   Description : Dialog to inspect stylesheet using xsldbg. Based on
                  file created by uic
*/
#ifndef XSLDBGINSPECTOR_H
#define XSLDBGINSPECTOR_H

#include <tqvariant.h>
#include <tqdialog.h>
class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQListBox;
class TQListBoxItem;
class TQPushButton;
class TQTabWidget;
class TQWidget;
class KPushButton;

class XsldbgDebugger;
class XsldbgBreakpointsImpl;
class XsldbgLocalVariablesImpl;
class XsldbgCallStackImpl;
class XsldbgTemplatesImpl;
class XsldbgSourcesImpl;
class XsldbgEntitiesImpl;

class XsldbgInspector : public TQDialog
{
    Q_OBJECT
  

public:
    XsldbgInspector( XsldbgDebugger *debugger, TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~XsldbgInspector();

    TQTabWidget* tabWidget;
    KPushButton* buttonHelp;
    KPushButton* buttonOk;
    KPushButton* buttonApply;
    TQPushButton* buttonRefresh;
    KPushButton* buttonCancel;


public slots:
   void accept();
   void reject();
   void refresh();
   void refreshBreakpoints();
   void refreshVariables();


protected:
    TQGridLayout* XsldbgInspectorLayout;
    TQHBoxLayout* Layout1;
    XsldbgDebugger *debugger;
    XsldbgBreakpointsImpl *breakpointWidget;
    XsldbgLocalVariablesImpl *localWidget;
    XsldbgCallStackImpl *callStackWidget;
    XsldbgTemplatesImpl *templateWidget;
    XsldbgSourcesImpl *sourceWidget;
    XsldbgEntitiesImpl *entityWidget;
};

#endif // XSLDBGINPECTOR_H
