/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef TQTDESIGNERINTEGRATION_H
#define TQTDESIGNERINTEGRATION_H

#include <tqmap.h>

#include <codemodel.h>
#include "kdevdesignerintegration.h"

class KDevLanguageSupport;
class ImplementationWidget;

/**
TQt Designer integration base class.
Contains language-independent implementation part of a @ref KDevDesignerIntegration interface.
Ready to use in KDevelop language support plugins.

Subclasses of this class should reimplement only pure virtual functions in the common case.
*/
class QtDesignerIntegration : public KDevDesignerIntegration
{
Q_OBJECT
  
public:
    QtDesignerIntegration(KDevLanguageSupport *part, ImplementationWidget *impl,
        bool classHasDefinitions, const char* name = 0);
    virtual ~QtDesignerIntegration();

public slots:
    virtual void addFunction(const TQString& formName, KInterfaceDesigner::Function function);
    virtual void editFunction(const TQString& formName, KInterfaceDesigner::Function oldFunction, KInterfaceDesigner::Function function);
    virtual void removeFunction(const TQString& formName, KInterfaceDesigner::Function function);

    virtual void openFunction(const TQString &formName, const TQString &functionName);
    
    virtual void openSource(const TQString &formName);
        
    virtual void saveSettings(TQDomDocument dom, TQString path);
    virtual void loadSettings(TQDomDocument dom, TQString path);

    bool selectImplementation(const TQString &formName);
    
protected:
    /**Reimplement this to add a function to a class. This means you need to modify
    the source file and add actual code of a function.*/
    virtual void addFunctionToClass(KInterfaceDesigner::Function function, ClassDom klass) = 0;
    /**Modifies name to be a name of a implementation file for languages that have
    separate files for interface and implementation parts of a class. For example,
    C++ language support plugin will do:
    @code
    name.replace(".h", ".cpp");
    @endcode*/
    virtual void processImplementationName(TQString &name);
    
    //Form file - derived class name 
    TQMap<TQString, ClassDom> m_implementations;
    
    KDevLanguageSupport *m_part;
    ImplementationWidget *m_impl;
    bool m_classHasDefinitions;
};

#endif
