/***************************************************************************
                 kfullscreenpanel.cpp  -  auto-hideable toolbar
                             -------------------
    begin                : Tue May 13 23:07:42 CET 2002
    copyright            : (C) 2002 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFULLSCREENPANEL_H
#define KFULLSCREENPANEL_H

#include <tqwidget.h>
#include <tqlayout.h>
#include <tqevent.h>
#include <tqtimer.h>

class Counter : public TQObject {
	Q_OBJECT
	
private:
	TQTimer m_timer;
	float m_stopValue, m_currentValue, m_stepSize;
	int m_timeoutMs;

public:
	Counter(float start);

	void count(float stop, float stepSize, float frequency);
private slots:
	void timeout();

signals:	
	void countingDownFinished();
	void countingUpFinished();
	void counted(float value);
};


class KFullscreenPanel : public TQWidget {
	Q_OBJECT
	
private:
	TQWidget *m_child;
	TQVBoxLayout *m_layout;
	TQSize    m_fsResolution;
	Counter m_counter;

	void doLayout();

public:
	KFullscreenPanel(TQWidget* parent, const char *name, 
			 const TQSize &resolution);
	~KFullscreenPanel();

	void setChild(TQWidget *child);
	void startShow();
	void startHide();

protected:
	void enterEvent(TQEvent *e);
	void leaveEvent(TQEvent *e);

private slots:
	void movePanel(float posY);
	
signals:
	void mouseEnter();
        void mouseLeave(); 
};

#endif
