/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef SMSSEND_H
#define SMSSEND_H

#include <tqobject.h>
#include <tqmap.h>
#include <tqlabel.h>

#include <klineedit.h>

#include "smsservice.h"

class SMSSendProvider;
class SMSSendPrefsUI;
class TQListViewItem;
class TQGridLayout;

class SMSSend : public SMSService
{
	Q_OBJECT
  
public:
	SMSSend(Kopete::Account* account);
	~SMSSend();

	virtual void setAccount(Kopete::Account* account);

	void send(const Kopete::Message& msg);
	void setWidgetContainer(TQWidget* parent, TQGridLayout* container);

	int maxSize();
	const TQString& description();

public slots:
	void savePreferences();

private slots:
	void setOptions(const TQString& name);
	void loadProviders(const TQString& prefix);
//signals:
//	void messageSent(const Kopete::Message&);

private:
	TQGridLayout *settingsBoxLayout;
	SMSSendProvider* m_provider;
	SMSSendPrefsUI* prefWidget;
	TQPtrList<KLineEdit> args;
	TQPtrList<TQLabel> labels;
	TQString m_description;
} ;

#endif //SMSSEND_H
