/*
    kircentity.h - IRC Client

    Copyright (c) 2004      by Michel Hermier <michel.hermier@wanadoo.fr>

    Kopete    (c) 2004      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KIRCENTITY_H
#define KIRCENTITY_H

#include <tdeversion.h>
#include <kresolver.h>
#include <ksharedptr.h>

#include <tqobject.h>
#include <tqregexp.h>
#include <tqstring.h>
#include <tqvaluelist.h>

namespace KIRC
{

class Engine;

class Entity
	: public TQObject,
	  public TDEShared
{
	Q_OBJECT
  

public:
	enum Type
	{
		Unknown,
		Server,
		Channel,
		Service,
		User
	};

	Entity(const TQString &name, const Type type = Unknown);
	virtual ~Entity();

	TQString name() const;
	TQString host() const;

	KIRC::Entity::Type type() const;
	KIRC::Entity::Type guessType();
	static KIRC::Entity::Type guessType(const TQString &name);

	// FIXME: Remove these is* functions ... They are duplicate with the ::guessType(const TQString&)
	inline static bool isUser( const TQString &s )
		{ return sm_userRegExp.exactMatch(s); };
	inline bool isChannel()
		{ return isChannel(m_name); };
	inline static bool isChannel( const TQString &s )
		{ return sm_channelRegExp.exactMatch(s); };

	TQString userNick() const;
	static TQString userNick(const TQString &s);

	TQString userName() const;
	static TQString userName(const TQString &s);

	TQString userHost() const;
	static TQString userHost(const TQString &s);

signals:
	void destroyed(KIRC::Entity *self);

private:

	static TQString userInfo(const TQString &s, int num_cap);

	static const TQRegExp sm_userRegExp;
	static const TQRegExp sm_userStrictRegExp;
	static const TQRegExp sm_channelRegExp;

	KIRC::Entity::Type m_type;
	TQString	m_name;

	// peer ip address if the entity is a User.
	TQString m_address;
};

class EntityPtr
	: public TDESharedPtr<KIRC::Entity>
{
public:
	EntityPtr(KIRC::Entity *entity = 0)
		: TDESharedPtr<KIRC::Entity>(entity)
	{ }

	EntityPtr(const KIRC::EntityPtr &entity)
		: TDESharedPtr<KIRC::Entity>(entity)
	{ }
};

class EntityPtrList
	: public TQValueList<EntityPtr>
{
public:
	EntityPtrList()
	{ }

	EntityPtrList(const EntityPtr &entity)
	{
		append(entity);
	}

	EntityPtrList(const TQValueList<EntityPtr> &list)
		: TQValueList<EntityPtr>(list)
	{ }
};

}

#endif
