/***************************************************************************
*                                tdemainwidget.h
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/


#ifndef _TDEMAINWIDGET_H_
#define _TDEMAINWIDGET_H_

#include <tdemainwindow.h>
#include <tdeaction.h>
#include <kurl.h>
#include "common.h"

#include "kget_iface.h"

class TDEAction;
//class TDEToggleAction;
class TDERadioAction;

class DockWidget;
class DropTarget;
class LogWindow;
class DlgPreferences;

class Transfer;
class TransferList;
class Settings;


class TDEMainWidget:public TDEMainWindow, virtual public KGetIface
{

  Q_OBJECT
  

public:
    enum StatusbarFields { ID_TOTAL_TRANSFERS = 1, ID_TOTAL_FILES, ID_TOTAL_SIZE,
                           ID_TOTAL_TIME         , ID_TOTAL_SPEED                };

    TDEMainWidget(bool bShowMain = false);
    ~TDEMainWidget();

    void addTransfer( const TQString& src );
    void addTransferEx( const KURL& url,
                        const KURL& destFile = KURL());

    // dcop interface
    virtual void addTransfers( const KURL::List& src, const TQString& destDir = TQString() );
    virtual bool isDropTargetVisible() const;
    virtual void setDropTargetVisible( bool setVisible );

    
    void checkQueue();

    void setListFont();
    void setAutoSave();
    void setAutoDisconnect();

    LogWindow *logwin()const { return logWindow;}
    friend class Settings;

    // Actions
    TDEToggleAction *m_paShowLog;
    TDEToggleAction *m_menubarAction;
    TDEAction *m_paPreferences;
    TDEAction *m_paQuit;
    bool b_viewLogWindow;

    void readTransfersEx(const KURL & url);

    void activateDropTarget();

public slots:
    void slotPasteTransfer();
    void slotToggleLogWindow();
    void slotPreferences();
    void slotConfigureNotifications();
    void slotToggleExpertMode();
    void slotToggleOfflineMode();
    void slotToggleUseLastDir();
    void slotToggleAutoDisconnect();
    void slotToggleAutoShutdown();
    void slotToggleAutoPaste();
    void slotToggleDropTarget();
    void slotToggleAnimation();
    void slotUpdateActions();
    void slotKonquerorIntegration();

protected slots:
    void slotQuit();

    void slotOpenTransfer();
    void slotExportTransfers();
    void slotImportTransfers();
    void slotImportTextFile();

    void slotSaveYourself();
    void slotCheckConnection();


    void slotStatusChanged(Transfer * item, int _operation);

    void slotResumeCurrent();
    void slotPauseCurrent();
    void slotDeleteCurrent();
    void slotRestartCurrent();

    void slotQueueCurrent();
    void slotTimerCurrent();
    void slotDelayCurrent();

    void slotOpenIndividual();

    void slotAnimTimeout();
    void slotTransferTimeout();
    void slotAutosaveTimeout();

    void slotMoveToBegin();
    void slotMoveToEnd();

    void slotCopyToClipboard();
    void slotCheckClipboard();

    void slotConfigureToolbars();
    void slotNewToolbarConfig();
    void slotShowMenubar();

    void slotPopupMenu(Transfer * item);

protected:
    virtual void setOfflineMode( bool online );
    virtual bool isOfflineMode() const;
    virtual bool queryClose();
    void writeLog();

    // drag and drop
    virtual void dragEnterEvent(TQDragEnterEvent *);
    virtual void dropEvent(TQDropEvent *);

    void readTransfers(bool ask_for_name = false);
    void writeTransfers(bool ask_for_name = false);


    void setupGUI();
    void setupWhatsThis();

    void updateStatusBar();

    // some flags
    bool b_connected;
    bool b_viewPreferences;

    // utility functions
    void onlineDisconnect();
    void checkOnline();
    void stopAll();
    void log(const TQString & message, bool statusbar = true);

    /** No descriptions */
    virtual void customEvent(TQCustomEvent * e);

    // various timers
    TQTimer *animTimer;          // animation timer
    TQTimer *connectionTimer;    // timer that checks whether we are online
    TQTimer *transferTimer;      // timer for scheduled transfers
    TQTimer *autosaveTimer;      // timer for autosaving transfer list
    TQTimer *clipboardTimer;     // timer for checking clipboard - autopaste function

    TQString logFileName;



private:
    TQString getSaveDirectoryFor( const TQString& filename ) const;
    bool sanityChecksSuccessful( const KURL& url );

    TransferList * myTransferList;
    KHelpMenu *menuHelp;

    LogWindow *logWindow;
    DlgPreferences *prefDlg;
    DockWidget *kdock;

    TQString lastClipboard;

    uint animCounter;

    int _sock;

    // Actions
    TDEAction *m_paOpenTransfer, *m_paPasteTransfer, *m_paExportTransfers, *m_paImportTransfers;
    TDEAction *m_paImportText;

    TDEAction *m_paMoveToBegin, *m_paMoveToEnd, *m_paCopy, *m_paIndividual;
    TDEAction *m_paResume, *m_paPause, *m_paDelete, *m_paRestart;
    TDERadioAction *m_paQueue, *m_paTimer, *m_paDelay;

    TDEToggleAction *m_paUseAnimation;
    TDEToggleAction *m_paExpertMode, *m_paUseLastDir, *m_paOfflineMode;
    TDEToggleAction *m_paAutoDisconnect, *m_paAutoShutdown, *m_paAutoPaste;

    TDEAction *m_paDropTarget;
    TDEAction *m_paKonquerorIntegration;
    bool m_showDropTarget;

};

extern TDEMainWidget *tdemain;
extern DropTarget *kdrop;

#endif                          // _TDEMAINWIDGET_H_
