/***************************************************************************
    smb4kmountdialog  -  This class provides a dialog for mounting shares
    manually.
                             -------------------
    begin                : Mo Nov 29 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqlayout.h>
#include <tqframe.h>
#include <tqgroupbox.h>
#include <tqlabel.h>

// KDE includes
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kdebug.h>

// application specific includes
#include "smb4kmountdialog.h"

#include "../core/smb4kmounter.h"
#include "../core/smb4kbookmarkhandler.h"
#include "../core/smb4kbookmark.h"
#include "../core/smb4kcore.h"
#include "../smb4k.h"

Smb4KMountDialog::Smb4KMountDialog( TQWidget *parent, const char *name ) :
KDialogBase( Plain, i18n( "Mount Share" ), Ok|Cancel, Ok, parent, name, true, true )
{
  setWFlags( TQt::WDestructiveClose );

  setupView();

  setFixedSize( (sizeHint().width() > 350 ? sizeHint().width() : 350), sizeHint().height() );
}


Smb4KMountDialog::~Smb4KMountDialog()
{
}


void Smb4KMountDialog::setupView()
{
  TQFrame *frame = plainPage();
  TQGridLayout *layout = new TQGridLayout( frame );
  layout->setSpacing( 5 );
  layout->setMargin( 0 );

  TQLabel *shareLabel = new TQLabel( i18n( "Share:" ), frame );
  m_share_input = new KLineEdit( frame, "ShareInputLine" );
  m_share_input->setMinimumWidth( 200 );
  m_share_input->setFocus();

  TQLabel *addressLabel = new TQLabel( i18n( "IP Address:" ), frame );
  m_ip_input = new KLineEdit( frame, "IPInputLine" );
  m_ip_input->setMinimumWidth( 200 );

  TQLabel *workgroupLabel = new TQLabel( i18n( "Workgroup:" ), frame );
  m_workgroup_input = new KLineEdit( frame, "WorkgroupInputLine" );
  m_workgroup_input->setMinimumWidth( 200 );

  m_bookmark = new TQCheckBox( i18n( "Add this share to the bookmarks" ), frame, "BookmarkButton" );

  layout->addWidget( shareLabel, 0, 0, 0 );
  layout->addWidget( m_share_input, 0, 1, 0 );
  layout->addWidget( addressLabel, 1, 0, 0 );
  layout->addWidget( m_ip_input, 1, 1, 0 );
  layout->addWidget( workgroupLabel, 2, 0, 0 );
  layout->addWidget( m_workgroup_input, 2, 1, 0 );
  layout->addMultiCellWidget( m_bookmark, 3, 3, 0, 1, 0 );

  connect( m_share_input, TQT_SIGNAL( textChanged ( const TQString & ) ) ,
           this,          TQT_SLOT( slotChangeInputValue( const TQString & ) ) );

  slotChangeInputValue( m_share_input->text() );
}


/////////////////////////////////////////////////////////////////////////////
//  TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KMountDialog::slotChangeInputValue( const TQString& _test)
{
  enableButtonOK( !_test.isEmpty() );
}

void Smb4KMountDialog::slotOk()
{
  // FIXME: Leave the decision if the share is not formatted
  // correctly up to the mounter. Just pass the string to
  // Smb4KCore::mounter()->mountShare().

  if ( !m_share_input->text().stripWhiteSpace().isEmpty() )
  {
#ifndef __FreeBSD__
    if ( m_share_input->text().contains( "/" ) == 3 )
#else
    if ( m_share_input->text().contains( "/" ) == 3
         && m_share_input->text().contains( '@' ) == 0 )
#endif
    {
      TQString host = m_share_input->text().stripWhiteSpace().section( "/", 2, 2 );
      TQString share = m_share_input->text().stripWhiteSpace().section( "/", 3, 3 );
      TQString ip = m_ip_input->text().stripWhiteSpace();
      TQString workgroup = m_workgroup_input->text().stripWhiteSpace();

      Smb4KCore::mounter()->mountShare( workgroup, host, ip, share );

      if ( m_bookmark->isChecked() )
      {
        Smb4KCore::bookmarkHandler()->addBookmark( new Smb4KBookmark( host, share, workgroup, ip, TQString() ) );
      }

      connect( Smb4KCore::mounter(), TQT_SIGNAL( state( int ) ), this, TQT_SLOT( slotMounterStateChanged( int ) ) );
    }
    else
    {
      KMessageBox::error( this, i18n( "The format of the share you entered is not correct. It must have the form //HOST/SHARE." ) );
    }
  }
}


void Smb4KMountDialog::slotCancel()
{
  Smb4KCore::mounter()->abort();

  KDialogBase::slotCancel();
}


void Smb4KMountDialog::slotMounterStateChanged( int state )
{
  switch ( state )
  {
    case MOUNTER_STOP:
    {
      accept();

      break;
    }
    default:
    {
      break;
    }
  }
}

#include "smb4kmountdialog.moc"

