/***************************************************************************
 *   Copyright (C) 2005-2006 by Niklas Knutsson                            *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEPREFERENCESDIALOG_H
#define QALCULATEPREFERENCESDIALOG_H

#include <kdialogbase.h>

class TQCheckBox;
class TQRadioButton;
class TQLabel;
class TDEFontRequester;
class KColorButton;

/**
@author Niklas Knutsson
*/
class QalculatePreferencesDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculatePreferencesDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculatePreferencesDialog();

	bool editPreferences();

	TQCheckBox *rpnKeypadOnlyButton, *systrayButton, *statusButton, *iconsButton, *fetchExchangeRatesButton, *saveModeButton, *saveDefsButton, *dotAsSeparatorButton, *unicodeButton, *lowerCaseButton, *lowerCaseEButton, *alternativeBasePrefixButton, *spellOutLogicalOperatorsButton, *useCustomResultFontButton, *useCustomExpressionFontButton, *useCustomStatusFontButton;
	TQRadioButton *dotButton, *exButton, *asteriskButton, *divisionSlashButton, *divisionButton, *slashButton;
	TQLabel *multiplicationLabel, *divisionLabel;
	TDEFontRequester *resultFontEdit, *expressionFontEdit, *statusFontEdit;
	KColorButton *statusErrorColorButton, *statusWarningColorButton;

protected slots:
	
	void slotApply();

};

#endif
