/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEIMPORTCSVDIALOG_H
#define QALCULATEIMPORTCSVDIALOG_H

#include <kdialogbase.h>

class KLineEdit;
class KComboBox;
class TQSpinBox;
class TQCheckBox;
class TQRadioButton;
class KURLRequester;

/**
@author Niklas Knutsson
*/
class QalculateImportCSVDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateImportCSVDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateImportCSVDialog();

	KLineEdit *nameEdit, *titleEdit, *otherDelimiterEdit;
	KComboBox *categoryCombo, *delimiterCombo;
	TQSpinBox *firstRowBox;
	TQCheckBox *includesHeadingsButton;
	TQRadioButton *matrixButton, *vectorsButton;
	KURLRequester *fileEdit;

	bool importCSVFile();

public slots:

	void delimiterChanged(int);
	void nameChanged(const TQString&);
	
protected slots:
	
	void slotHelp();
	void slotOk();

};

#endif
