/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEDATASETSDIALOG_H
#define QALCULATEDATASETSDIALOG_H

#include <kdialogbase.h>
#include <tqmap.h>

class TQPushButton;
class TDEListView;
class KTextBrowser;
class TQScrollView;
class TQGrid;
class DataSet;
class DataObject;
class QalculateEditDataSetDialog;
class QalculateEditDataObjectDialog;

/**
@author Niklas Knutsson
*/
class QalculateDataSetsDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateDataSetsDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateDataSetsDialog();

	TQPushButton *newObjectButton, *editObjectButton, *deleteObjectButton, *newDataSetButton, *editDataSetButton, *deleteDataSetButton;
	TDEListView *objectsView, *dataSetsView;
	KTextBrowser *descriptionBrowser;
	TQScrollView *attributesView;
	TQGrid *attributesGrid;

	TQMap<TQListViewItem*, DataSet*> dataSetItems;
	TQMap<TQListViewItem*, DataObject*> objectItems;

	DataSet *selected_dataset;
	DataObject *selected_object;

	QalculateEditDataSetDialog *dataset_edit_dialog;
	QalculateEditDataObjectDialog *object_edit_dialog;

public slots:

	void updateDataSetTree();
	void dataSetDoubleClicked(TQListViewItem*);
	void objectDoubleClicked(TQListViewItem*);
	void dataSetSelected();
	void objectSelected();
	void deleteDataSet();
	void editDataSet();
	void newDataSet();
	void deleteObject();
	void editObject();
	void newObject();
	void updateObjects();
	void insertObjectData(void*);

signals:

	void dataSetsChanged();

};

#endif
