/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
                 2001       Sven Leiber         <s.leiber@web.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef koautoformatdia_h
#define koautoformatdia_h

#include <kdialogbase.h>
#include <tqlineedit.h>
#include <KoAutoFormat.h>
class TQCheckBox;
class KCharSelect;
class TQComboBox;


/**
 *
 */
class KoAutoFormatLineEdit : public TQLineEdit
{
    Q_OBJECT
  
public:
    KoAutoFormatLineEdit ( TQWidget * parent, const char * name=0 );

protected:
    virtual void keyPressEvent ( TQKeyEvent * );
 signals:
    void keyReturnPressed();
};

/******************************************************************/
/* Class: KoAutoFormatExceptionWidget                             */
/******************************************************************/

class KoAutoFormatExceptionWidget : public TQWidget
{
    Q_OBJECT
  

public:
    KoAutoFormatExceptionWidget(TQWidget *_parent, const TQString &name,const TQStringList &_list, bool _autoInclude, bool _abbreviation=false);

    void setListException( const TQStringList &list);
    TQStringList getListException(){return m_listException;}
    bool autoInclude();
    void setAutoInclude( bool b );
protected slots:
    void slotAddException();
    void slotRemoveException();
    void textChanged ( const TQString & );
    void slotExceptionListSelected();
 private:
    TQListBox *exceptionList;
    KoAutoFormatLineEdit *exceptionLine;
    TQPushButton *pbAddException,*pbRemoveException;
    TQCheckBox *cbAutoInclude;
    TQStringList m_listException;
    bool m_bAbbreviation;
};

/******************************************************************/
/* Class: KoAutoFormatDia                                         */
/******************************************************************/

class KOTEXT_EXPORT KoAutoFormatDia : public KDialogBase
{
    Q_OBJECT
  

public:
    KoAutoFormatDia( TQWidget *parent, const char *name, KoAutoFormat * autoFormat );
    ~KoAutoFormatDia();
    void addEntryList(const TQString &key, KoAutoFormatEntry *_autoEntry);
    void editEntryList(const TQString &key,const TQString &newFindString, KoAutoFormatEntry *_autoEntry);
protected:
    bool applyConfig();
    void setupTab1();
    void setupTab2();
    void setupTab3();
    void setupTab4();

    void refreshEntryList();

    void initTab1();
    void initTab2();
    void initTab3();
    void initTab4();

    typedef TQMap<TQString, TQString> KoExceptionLanguageName;
    KoExceptionLanguageName exceptionLanguageName;

    TQWidget *tab1;
    TQWidget *tab2;
    TQWidget *tab3;
    TQWidget *tab4;

    TQComboBox *autoFormatLanguage;

    TQCheckBox *cbTypographicSimpleQuotes, *cbTypographicDoubleQuotes,*cbUpperCase, *cbUpperUpper, *cbDetectUrl,
        *cbBackgroundSpellCheck, *cbAdvancedAutoCorrection,*cbIgnoreDoubleSpace , *cbRemoveSpaceBeginEndLine, *cbUseBulletStyle, *cbAutoChangeFormat, *cbAutoReplaceNumber, *cbUseNumberStyle, *cbAutoSuperScript, *cbAutoCorrectionWithFormat, *cbCapitalizeDaysName;
    TQPushButton *pbDoubleQuote1, *pbDoubleQuote2, /**pbEdit,*/ *pbRemove, *pbAdd, *pbDoubleDefault,
                *pbSpecialChar1, *pbSpecialChar2, *pbBulletStyle, *pbDefaultBulletStyle;

    TQPushButton *pbSimpleQuote1, *pbSimpleQuote2, *pbSimpleDefault;
    TQPushButton *pbChangeFormat, *pbClearFormat;
    KCharSelect *charselect;
    KoAutoFormatLineEdit *m_find, *m_replace;
    TDEListView *m_pListView;

    TQChar oSimpleBegin, oSimpleEnd;
    TQChar oDoubleBegin, oDoubleEnd;

    TQChar bulletStyle;
    KoAutoFormat m_autoFormat; // The copy we're working on
    KoAutoFormat * m_docAutoFormat; // Pointer to the real one (in KWDocument)

    KoAutoFormatExceptionWidget *abbreviation;
    KoAutoFormatExceptionWidget *twoUpperLetter;

    KoAutoFormatEntry *newEntry;

    TQString initialLanguage;
    bool noSignal;
    bool changeLanguage;

    bool autocorrectionEntryChanged;
protected slots:
    virtual void slotOk();
    virtual void slotCancel();

    void slotBulletStyleToggled( bool );
    void slotItemRenamed(TQListViewItem * item, const TQString & newText, int column);
    void slotRemoveEntry();
    void slotEditEntry();
    void slotfind( const TQString & );
    void slotfind2( const TQString & );
    void chooseSpecialChar1();
    void chooseSpecialChar2();
    void chooseDoubleQuote1();
    void chooseDoubleQuote2();
    void defaultDoubleQuote();

    void chooseSimpleQuote1();
    void chooseSimpleQuote2();
    void defaultSimpleQuote();

    void slotChangeStateSimple(bool);
    void slotChangeStateDouble(bool);

    void slotAddEntry();
    void chooseBulletStyle();
    void defaultBulletStyle();
    void slotChangeTextFormatEntry();
    void slotResetConf();
    void changeAutoformatLanguage(const TQString & );
    void slotClearTextFormatEntry();
    void slotChangeAdvancedAutoCorrection();
};

#endif
