//
// C++ Implementation: komposefullscreenwidget
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "komposefullscreenwidget.h"

#include "komposedesktopwidget.h"
#include "komposetaskwidget.h"
#include "komposeviewmanager.h"
#include "komposetaskmanager.h"
#include "komposeglobal.h"
#include "komposelayout.h"

#include <tqobjectlist.h>
#include <tqptrlist.h>
#include <tqpainter.h>
#include <tqdesktopwidget.h>

#include <twin.h>
#include <tdeapplication.h>
#include <tdepopupmenu.h>
#include <tdeaction.h>
#include <ksharedpixmap.h>
#include <kcursor.h>
#include <tdeglobalsettings.h>
#include <kdebug.h>
#include <krootpixmap.h>

KomposeFullscreenWidget::KomposeFullscreenWidget( int displayType, KomposeLayout *l )
    : KomposeTaskContainerWidget( -1, 0, l ),
    type(displayType)
{
  //   if ( TQT_VERSION < 0x030300 )

  /* use showMaximized instead of setWindowState to make it compile on qt 3.1 or whatever */
  //   showMaximized();
  //   KWin::setState( winId(), NET::KeepAbove );

  // Set Desktop background as our background
  setBackgroundMode( TQt::FixedPixmap );
//   setBackgroundPixmap(*(KomposeGlobal::instance()->getDesktopBgPixmap()));
  rootpix = new KRootPixmap (this);

  // Background blur -- exactly like done in Kicker
  if (KomposeSettings::instance()->getBlurBackground())
    rootpix->setBlurEffect(0.0, 2.0);
  else
    rootpix->setBlurEffect(0.0, 0.0);

  rootpix->start();
  initMenu();
  initView();
  //showFullScreen();

  // Alternate showFullscreen
  setWindowState(windowState() | WindowFullScreen);
  //setWFlags(WStyle_NoBorder);

    kdDebug() << KomposeSettings::instance()->getViewScreen() << endl;
  if (KomposeSettings::instance()->getViewScreen() == -1)
    setGeometry( TDEGlobalSettings::desktopGeometry( this ) );
  else
  {
    TQDesktopWidget deskwidget;
    TQRect deskRect = deskwidget.screenGeometry(KomposeSettings::instance()->getViewScreen());
    setGeometry(deskRect);
    kdDebug() << deskRect << endl;
  }

  if (!isTopLevel())
    TQApplication::sendPostedEvents(this, TQEvent::ShowFullScreen);
  setActiveWindow();

  KWin::setOnAllDesktops( winId(), true );
}

KomposeFullscreenWidget::~KomposeFullscreenWidget()
{
  menu->deleteLater();
}


void KomposeFullscreenWidget::initMenu()
{
  menu = new TDEPopupMenu();

  KomposeGlobal::instance()->getActShowWorldView()->plug(menu);
  KomposeGlobal::instance()->getActShowVirtualDesktopView()->plug(menu);
  KomposeGlobal::instance()->getActShowCurrentDesktopView()->plug(menu);
  menu->insertSeparator();
  KomposeGlobal::instance()->getActPreferencesDialog()->plug(menu);
  KomposeGlobal::instance()->getActConfigGlobalShortcuts()->plug(menu);
  KomposeGlobal::instance()->getActAboutDlg()->plug(menu);
  //menu->insertSeparator();
  //KomposeGlobal::instance()->getActQuit()->plug(menu);
}


void KomposeFullscreenWidget::destroyChildWidgets()
{
  setUpdatesEnabled( false );
  KomposeWidget *child;
  TQPtrListIterator<KomposeWidget> it( *(layout->getManagedWidgets()));
  while ( (child = it.current()) != 0 )
  {
    ++it;
    layout->remove(child);
    dynamic_cast<TQWidget*>(child)->deleteLater();
  }
  setUpdatesEnabled( true );
  kdDebug() << "KomposeFullscreenWidget::destroyChildWidgets() - all children destroyed" << endl;
}

void KomposeFullscreenWidget::initView()
{
  setCursor( KCursor::waitCursor() );

  destroyChildWidgets();

  if ( type == KOMPOSEDISPLAY_VIRTUALDESKS )
  {
    disconnect( KomposeTaskManager::instance(), SIGNAL( newTask( KomposeTask* ) ), this, SLOT( createTaskWidget( KomposeTask* ) ) );
    layout->setType( TLAYOUT_TASKCONTAINERS );
    setDesktop( -2 );
    createDesktopWidgets();
  }
  else if ( type == KOMPOSEDISPLAY_WORLD )
  {
    layout->setType( TLAYOUT_GENERIC );
    setDesktop( -1 );
    createTaskWidgets();
    connect( KomposeTaskManager::instance(), SIGNAL( newTask( KomposeTask* ) ), this, SLOT( createTaskWidget( KomposeTask* ) ) );
  }
  else if ( type == KOMPOSEDISPLAY_CURRENTDESK )
  {
    layout->setType( TLAYOUT_GENERIC );
    setDesktop( KomposeViewManager::instance()->getDesktopBeforeSnaps() );
    createTaskWidgets();
    connect( KomposeTaskManager::instance(), SIGNAL( newTask( KomposeTask* ) ), this, SLOT( createTaskWidget( KomposeTask* ) ) );
  }

  unsetCursor();
}

void KomposeFullscreenWidget::createDesktopWidgets()
{
  kdDebug() << "KomposeFullscreenWidget::createDesktopWidgets()" << endl;
  // Create a Widget for every desktop
  for (int i=0; i < KomposeTaskManager::instance()->getNumDesktops(); ++i)
  {
    //int row = i / 2;
    //int col = i % 2;
    //kdDebug() << "rc %d %d", row, col);
    KomposeDesktopWidget *desktop = new KomposeDesktopWidget(i, this );
    connect( desktop, SIGNAL(contentsChanged()), layout, SLOT(arrangeLayout()) );
    connect( desktop, SIGNAL(activated(KomposeDesktopWidget*)), this, SLOT(desktopChanged(KomposeDesktopWidget*)) );
    desktop->show();
  }
}

void KomposeFullscreenWidget::mouseReleaseEvent (TQMouseEvent * )
{}

void KomposeFullscreenWidget::mousePressEvent ( TQMouseEvent * e )
{
  if ( !rect().contains( e->pos() ) )
    return;

  switch ( e->button() )
  {
  case LeftButton:
    kdDebug() << "KomposeFullscreenWidget::mousePressEvent - Clicked outside of all tasks - Closing view" << endl;
    KomposeViewManager::instance()->closeCurrentView();
    break;
  case MidButton:
    // fall through
  case RightButton:
    menu->popup( e->globalPos() );
    break;
  default:
    // nothing
    break;
  }
}

void KomposeFullscreenWidget::keyPressEvent( TQKeyEvent *e )
{
  if ( e->key() == TQt::Key_Control )
  {
    e->accept();
  }
}

void KomposeFullscreenWidget::keyReleaseEvent ( TQKeyEvent *e )
{
  if ( e->key() == TQt::Key_Escape )
  {
    kdDebug() << "KomposeFullscreenWidget::keyReleaseEvent - Esc key pressed - Closing view" << endl;
    KomposeViewManager::instance()->closeCurrentView();
    e->accept();
  }

  else if ( e->key() == TQt::Key_Control )
  {
    e->accept();
    return;
  }

  // Movement keys
  else if ( e->key() == TQt::Key_Right || e->key() == TQt::Key_D || e->key() == TQt::Key_H ||
            e->key() == TQt::Key_Left  || e->key() == TQt::Key_A || e->key() == TQt::Key_J ||
            e->key() == TQt::Key_Up    || e->key() == TQt::Key_W || e->key() == TQt::Key_K ||
            e->key() == TQt::Key_Down  || e->key() == TQt::Key_S || e->key() == TQt::Key_L )
  {
        // Map keys to directions
    int direction = DLAYOUT_RIGHT;
    switch( e->key() )
    {
    case TQt::Key_Right:
    case TQt::Key_D:
    case TQt::Key_L:
      direction = DLAYOUT_RIGHT;
      break;
    case TQt::Key_Left:
    case TQt::Key_A:
    case TQt::Key_H:
      direction = DLAYOUT_LEFT;
      break;
    case TQt::Key_Up:
    case TQt::Key_W:
    case TQt::Key_K:
      direction = DLAYOUT_TOP;
      break;
    case TQt::Key_Down:
    case TQt::Key_S:
    case TQt::Key_J:
      direction = DLAYOUT_BOTTOM;
      break;
    }

    focusNeighbourDesk( direction );
    e->accept();
    return;
  }

  else
  {
    kdDebug() << "KomposeFullscreenWidget::keyReleaseEvent - ignored..." << endl;
    e->ignore();
  }

  KomposeTaskContainerWidget::keyReleaseEvent(e);
}

bool KomposeFullscreenWidget::focusNeighbourDesk( int direction )
{
  bool successfull = false;
  KomposeWidget *widget;
  if ( ( widget = layout->getNeighbour( dynamic_cast<KomposeWidget*>(current), direction, WLAYOUT_BOTH  ) ) != 0 )
  {
    kdDebug() << "KomposeFullscreenWidget::keyReleaseEvent - Focussing " << widget->className() << endl;
    dynamic_cast<KomposeDesktopWidget*>(widget)->setActive();
    successfull = true;
  }

  return successfull;
}

void KomposeFullscreenWidget::desktopChanged( KomposeDesktopWidget* desk )
{
  kdDebug() << "KomposeFullscreenWidget: desktopChanged" << endl;
  // Remove highlight from all other desks
  const TQObjectList *lst = children();

  if( lst )
  {
    TQObjectListIterator it( *lst );
    TQWidget *widget;
    while ( (widget = (TQWidget*)it.current() ) )
    {
      if ( widget->inherits("KomposeDesktopWidget") )
      {
        dynamic_cast<KomposeDesktopWidget*>(widget)->clearHighlight();
      }
      ++it;
    }
  }

  desk->setHighlight();
  current = desk;
}

int KomposeFullscreenWidget::getHeightForWidth ( int w ) const
{
  return (int)(((double)w / (double)width()) * (double)height());
}

int KomposeFullscreenWidget::getWidthForHeight ( int h ) const
{
  return (int)(((double)h / (double)height()) * (double)width());
}

double KomposeFullscreenWidget::getAspectRatio()
{
  return (double)width() / (double)height();
}

// void KomposeFullscreenWidget::paintEvent ( TQPaintEvent * )
// {
//   TQPainter p( this );
//   p.drawPixmap(rect(), *(KomposeGlobal::instance()->getDesktopBgPixmap()));
//   p.end();
// }


#include "komposefullscreenwidget.moc"
