/***************************************************************************
                          quickbar.h  -  description
                             -------------------
    begin                : Mon Feb 11 2002
    copyright            : (C) 2002 by Martin Witte / Klas Kalass
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_QUICKBAR_H
#define KRADIO_QUICKBAR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqwidget.h>

#include "../../src/include/radio_interfaces.h"
#include "../../src/include/widgetplugins.h"
#include "../../src/include/stationselection_interfaces.h"

class ButtonFlowLayout;
class TQButtonGroup;
class TDEConfig;
class TQToolButton;

/**
  *@author Martin Witte / Klas Kalass
  */

class QuickBar : public TQWidget,
                 public WidgetPluginBase,
                 public IRadioClient,
                 public IStationSelection
{
Q_OBJECT
  
public:
    QuickBar(const TQString &name = TQString());
    ~QuickBar();

    virtual TQString pluginClassName() const { return "QuickBar"; }

    const TQString &name() const { return PluginBase::name(); }
          TQString &name()       { return PluginBase::name(); }

    virtual bool   connectI(Interface *i);
    virtual bool   disconnectI(Interface *i);

    // IStationSelection

RECEIVERS:
    bool setStationSelection(const TQStringList &sl);

ANSWERS:
    const TQStringList & getStationSelection () const { return m_stationIDs; }


    // PluginBase

public:
    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();

    // IRadioClient

RECEIVERS:
    bool noticePowerChanged(bool on);
    bool noticeStationChanged (const RadioStation &, int idx);
    bool noticeStationsChanged(const StationList &sl);
    bool noticePresetFileChanged(const TQString &/*f*/)           { return false; }

    bool noticeCurrentSoundStreamIDChanged(SoundStreamID /*id*/) { return false; }

    // button/station Management


protected slots:

    void    buttonClicked(int id);

protected:

    int     getButtonID(const RadioStation &rs) const;
    void    activateCurrentButton();
    void    activateButton(const RadioStation &);

    void    autoSetCaption();


    void    dragEnterEvent(TQDragEnterEvent* event);
    void    dropEvent(TQDropEvent* event);

    // KDE/QT

public slots:

    void    toggleShown() { WidgetPluginBase::pToggleShown(); }
    void    show();
    void    hide();
    void    showOnOrgDesktop();
    void    setGeometry (const TQRect &r);
    void    setGeometry (int x, int y, int w, int h);

protected:
    void    rebuildGUI();
    void    showEvent(TQShowEvent *);
    void    hideEvent(TQHideEvent *);
    void    resizeEvent(TQResizeEvent *);

    const TQWidget *getWidget() const { return this; }
          TQWidget *getWidget()       { return this; }

protected :

    ButtonFlowLayout *m_layout;
    TQButtonGroup     *m_buttonGroup;

    TQPtrList<TQToolButton> m_buttons;

    // config
    bool              m_showShortName;
    TQStringList       m_stationIDs;

    bool              m_ignoreNoticeActivation;
};
#endif
