/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-02-17
 * Description : a plugin to change image perspective.
 *
 * Copyright (C) 2005-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef IMAGEEFFECT_PERSPECTIVE_H
#define IMAGEEFFECT_PERSPECTIVE_H

// TQt includes.

#include <tqrect.h>

// Digikam includes.

#include "editortool.h"

class TQLabel;
class TQCheckBox;

class KColorButton;

namespace KDcrawIface
{
class RIntNumInput;
}

namespace Digikam
{
class EditorToolSettings;
}

namespace DigikamPerspectiveImagesPlugin
{

class PerspectiveWidget;

class PerspectiveTool : public Digikam::EditorTool
{
    Q_OBJECT
  

public:

    PerspectiveTool(TQObject* parent);
    ~PerspectiveTool();

private slots:

    void slotResetSettings();
    void slotUpdateInfo(TQRect newSize, float topLeftAngle, float topRightAngle,
                        float bottomLeftAngle, float bottomRightAngle);

private:

    void readSettings();
    void writeSettings();
    void finalRendering();

private:

    TQLabel                      *m_newWidthLabel;
    TQLabel                      *m_newHeightLabel;
    TQLabel                      *m_topLeftAngleLabel;
    TQLabel                      *m_topRightAngleLabel;
    TQLabel                      *m_bottomLeftAngleLabel;
    TQLabel                      *m_bottomRightAngleLabel;

    TQCheckBox                   *m_drawWhileMovingCheckBox;
    TQCheckBox                   *m_drawGridCheckBox;

    KDcrawIface::RIntNumInput   *m_guideSize;

    KColorButton                *m_guideColorBt;

    PerspectiveWidget           *m_previewWidget;

    Digikam::EditorToolSettings *m_gboxSettings;
};

}  // NameSpace DigikamPerspectiveImagesPlugin

#endif /* IMAGEEFFECT_PERSPECTIVE_H */
