//
// C++ Interface: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9PREFMENCODER_H
#define K9PREFMENCODER_H

#include "k9common.h"
#include "prefMencoder.h"
#include "k9videocodecs.h"
#include "k9audiocodecs.h"
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqlineedit.h>

class k9prefMencoder : public prefMencoder
{
  Q_OBJECT
  

public:
  k9prefMencoder(TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~k9prefMencoder();
  /*$PUBLIC_FUNCTIONS$*/
  void save(void);
  void load();
public slots:
  /*$PUBLIC_SLOTS$*/
   void teOptATextChanged();

   void teOpt1TextChanged();
   void teOpt3TextChanged();
   void teOpt2TextChanged();
   void leVLabelTextChanged(const TQString &);
   void leALabelTextChanged(const TQString &);
   void leFourccTextChanged(const TQString &);
private:
    k9VideoCodecs m_codecs;
    k9AudioCodecs m_audioCodecs;
    bool m_update;
protected slots:
  /*$PROTECTED_SLOTS$*/
  void lbvCodecsCurrentChanged(TQListBoxItem *_item);
  void lbaCodecsCurrentChanged(TQListBoxItem *_item);
  void btnOpt1Clicked();
  void btnOpt2Clicked();
  void btnOpt3Clicked();
  void btnOptAClicked();
  void btnAddVClicked();
  void btnDeleteVClicked();
  void btnAddAClicked();
  void btnDeleteAClicked();
  void bResetClicked();
};


#endif

