/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.
 *                                                                         *
 ***************************************************************************/

#include "page_rmbmenu.h"

#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqpushbutton.h>

#include <kdebug.h>

#include "../usercontrolmenu.h"



PageRMBMenu::PageRMBMenu( TQWidget *parent, const char *name ) : PageRMBMenuBase( parent, name)
{
    UserControlMenu *ucm;

    UserControlMenu::parseTDEConfig();

    commandLB->clear();
    for(ucm = UserControlMenu::UserMenu.first();
	ucm != 0;
	ucm = UserControlMenu::UserMenu.next()){

	if(ucm->type == UserControlMenu::Seperator){
            commandLB->insertItem("--------------", -1);
	}
	else{
	    commandLB->insertItem(ucm->title, -1);
	}
    }

    changeItemPB->hide();

    connect(commandLB, TQT_SIGNAL(highlighted( int )),
            this, TQT_SLOT(highlighted( int )));
    connect(moveUpPB, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(moveDown()));
    connect(moveDownPB, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(moveUp()));

    connect(insertSeperatorPB, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(insSeperator()));

    connect(insertItemPB, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(insCommand()));

    connect(deleteItemPB, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(delCommand()));

}

PageRMBMenu::~PageRMBMenu()
{
}

void PageRMBMenu::saveConfig()
{
    UserControlMenu::writeTDEConfig();
}

void PageRMBMenu::readConfig( const KSORMBMenu * )
{
}

void PageRMBMenu::defaultConfig()
{
}

void PageRMBMenu::highlighted(int index)
{
    UserControlMenu *ucm;

    ucm = UserControlMenu::UserMenu.at(index);

    if(ucm == 0)
        return;

    if(ucm->type == UserControlMenu::Seperator){
	entryLE->setEnabled(false);
	commandLE->setEnabled(false);
	opEnableCB->setEnabled(false);
	opEnableCB->setChecked(false);
	changeItemPB->setEnabled(false);
    }
    else{
	entryLE->setEnabled(true);
	commandLE->setEnabled(true);
	opEnableCB->setEnabled(true);
	opEnableCB->setChecked(true);
	changeItemPB->setEnabled(true);

	entryLE->setText(ucm->title);
	commandLE->setText(ucm->action);
	opEnableCB->setChecked(ucm->op_only);
    }

    if(index == 0){
	moveUpPB->setEnabled(true);
	moveDownPB->setEnabled(false);
    }
    else if((uint)index == (commandLB->count()-1)){
	moveUpPB->setEnabled(false);
	moveDownPB->setEnabled(true);
    }
    else {
	moveUpPB->setEnabled(true);
	moveDownPB->setEnabled(true);
    }
}

void PageRMBMenu::moveUp()
{
    int item = commandLB->currentItem();

    TQString txt = commandLB->text(item);
    commandLB->removeItem(item);

    commandLB->insertItem(txt, item-1);
    commandLB->setCurrentItem(item-1);

    UserControlMenu *ucm = UserControlMenu::UserMenu.take(item);
    UserControlMenu::UserMenu.insert(item-1,ucm);

    highlighted(item-1);
    emit modified();
}

void PageRMBMenu::moveDown()
{
    int item = commandLB->currentItem();

    TQString txt = commandLB->text(item);
    commandLB->removeItem(item);

    commandLB->insertItem(txt, item+1);
    commandLB->setCurrentItem(item+1);

    UserControlMenu *ucm = UserControlMenu::UserMenu.take(item);
    UserControlMenu::UserMenu.insert(item+1,ucm);

    highlighted(item+1);
    emit modified();
}

void PageRMBMenu::insSeperator()
{
    int item = commandLB->currentItem();

    TQString txt = commandLB->text(item);

    commandLB->insertItem("--------------", item);
    commandLB->setCurrentItem(item);

    UserControlMenu::UserMenu.insert(item,new UserControlMenu); // Defaults to a separator

    highlighted(item);
    emit modified();
}

void PageRMBMenu::insCommand()
{
    int item = commandLB->currentItem();

    TQString te = entryLE->text();
    TQString ce = commandLE->text();

    commandLB->insertItem(te, item);
    commandLB->setCurrentItem(item);

    UserControlMenu::UserMenu.insert(item,
				     new UserControlMenu(
							 te,
							 ce,
							 0x0,
							 UserControlMenu::Text
							)); // Defaults to a separator

    highlighted(item);
    emit modified();
}

void PageRMBMenu::delCommand()
{
    int item = commandLB->currentItem();

    TQString txt = commandLB->text(item);
    commandLB->removeItem(item);

    UserControlMenu::UserMenu.remove(item);

    highlighted(item);
    emit modified();
}


#include "page_rmbmenu.moc"
