/*
    kopeteballoon.h  -  Nice Balloon

    Copyright (c) 2002      by Duncan Mac-Vicar Prett <duncan@kde.org>

    Kopete    (c) 2002-2005      by the Kopete developers  <kopete-devel@kde.org>

    Portions of this code based on Kim Applet code
    Copyright (c) 2000-2002 by Malte Starostik        <malte@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETEBALLOON_H
#define KOPETEBALLOON_H

#include <tqwidget.h>
#include <kactivelabel.h>

/**
 * A class derived from KActiveLabel so we can handle how
 * links are opened.
 */
class KopeteActiveLabel : public KActiveLabel
{
	Q_OBJECT
  

public:
	KopeteActiveLabel( TQWidget *parent = 0, const char* name = 0 );
	KopeteActiveLabel( const TQString& text, TQWidget *parent = 0, const char* name = 0 );

public slots:
	virtual void openLink( const TQString &link );
};



/**
 * A little balloon for notifications
 *
 * @author Malte Starostik <malte@kde.org>
 * @author Duncan Mac-Vicar Prett <duncan@kde.org>
 */
class KopeteBalloon : public TQWidget
{
	Q_OBJECT
  

public:
	KopeteBalloon(const TQString &text, const TQString &pic);
//	KopeteBalloon();

	void setAnchor(const TQPoint &anchor);

signals:
	void signalButtonClicked();
	void signalIgnoreButtonClicked();
	void signalBalloonClicked();
	void signalTimeout();

protected:
	virtual void updateMask();

private:
	TQPoint mAnchor;
};

#endif
