//
//   File : channelsjoinwindow.h
//   Creation date : Thu Nov 06 2001 12:30:25 CEST by Juan Jos��varez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//


#ifndef _CHANNELSJOIN_H_
#define _CHANNELSJOIN_H_
#include "kvi_window.h"
#include "kvi_string.h"

#include <tqdialog.h>

class KviConsole;
class KviTalGroupBox;
class TQPushButton;
class TQLineEdit;

#include "kvi_styled_controls.h"
#include "kvi_tal_listview.h"

class KviChannelsJoinWindow : public TQDialog
{
	Q_OBJECT
  
public:
	KviChannelsJoinWindow(TQWidget * par, const char * name);
	~KviChannelsJoinWindow();
protected:
	TQLineEdit   * m_pChannelEdit; 
	KviTalListView   * m_pListView;
	KviTalGroupBox   * m_pGroupBox;
	TQLineEdit   * m_pPass;
	KviStyledCheckBox   * m_pShowAtStartupCheck;
	KviStyledCheckBox   * m_pCloseAfterJoinCheck;
	TQPushButton * m_pJoinButton;
	KviConsole  * m_pConsole;
public:
	virtual void closeEvent(TQCloseEvent *e);
	void fillListView();
	void enableJoin();
	void setConsole(KviConsole  * pConsole);
protected slots:
	void editTextChanged(const TQString &);
	void itemClicked(KviTalListViewItem *it);
	void itemDoubleClicked(KviTalListViewItem *it);
	void editReturnPressed();
	void cancelClicked();
	void joinClicked();
//	void whoClicked();
//	void namesClicked();
};
	
#endif //_CHANNELSJOINSWINDOW_H_
