#!/usr/bin/env python

# TQt tutorial 7.

import sys
from python_tqt import qt


class LCDRange(qt.TQVBox):
    def __init__(self, parent=None, name=None):
        qt.TQVBox.__init__(self, parent, name)

        lcd = qt.TQLCDNumber(2, self, "lcd")
        self.slider = qt.TQSlider(qt.TQt.Horizontal, self, "slider")
        self.slider.setRange(0, 99)
        self.slider.setValue(0)
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), lcd, qt.SLOT("display(int)"))
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), self, qt.PYSIGNAL("valueChanged(int)"))

    def value(self):
        return self.slider.value()

    def setValue(self, value):
        self.slider.setValue(value)


class MyWidget(qt.TQVBox):
    def __init__(self, parent=None, name=None):
        qt.TQVBox.__init__(self, parent, name)

        quit = qt.TQPushButton("Quit", self, "quit")
        quit.setFont(qt.TQFont("Times", 18, qt.TQFont.Bold))

        self.connect(quit, qt.SIGNAL("clicked()"), qt.tqApp, qt.SLOT("quit()"))

        grid = qt.TQGrid(4, self)

        self.lcdlist = []
        previous = None

        for r in range(4):
            for c in range(4):
                lr = LCDRange(grid)

                if previous:
                    self.connect(lr, qt.PYSIGNAL("valueChanged(int)"), previous.setValue)

                previous = lr
                self.lcdlist.append(lr)


a = qt.TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
