/***************************************************************************
 *   Copyright (C) 2004 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KDEVPART_CTAGS2_H__
#define __KDEVPART_CTAGS2_H__

#include <tqguardedptr.h>
#include <tqstring.h>

#include <kdevplugin.h>
#include "tags.h"

class TQPopupMenu;
class Context;
class KURL;
class TQTextStream;
class CTags2Widget;
class ConfigWidgetProxy;
class KDialogBase;

class CTags2Part : public KDevPlugin
{
  Q_OBJECT
  

public:
   
	CTags2Part(TQObject *parent, const char *name, const TQStringList &);
	~CTags2Part();

	int getFileLineFromPattern( KURL const & url, TQString const & pattern);
	bool createTagsFile();
	bool createTagsFile(const TQString& tagFile, const TQString& dir);

private slots:
	void slotLookupDeclaration();
	void slotLookupDefinition();
	void slotLookup();
	void slotOpenLookup();
	void slotGoToNext();
	void slotGotoDefinition();
	void slotGotoDeclaration();
	void slotGotoTag();
	void contextMenu(TQPopupMenu *, const Context *);
	void insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int );
	void updateTagsfileName( const TQString & name );
	
private:
	int getFileLineFromStream( TQTextStream & stream, TQString const & pattern);
	void gotoTagForTypes( TQStringList const & types );
	void showHits( Tags::TagList const & tags );
    
	TQGuardedPtr<CTags2Widget> m_widget;
	TQString m_contextString ;
	
	ConfigWidgetProxy * _configProxy;
};


#endif
