/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2007-16-07
 * Description : a kipi plugin to export images to Picasa web service
 *
 * Copyright (C) 2007-2008 by Vardhman Jain <vardhman at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlabel.h>
#include <tqframe.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>

// KDE includes.

#include <kdebug.h>
#include <tdelocale.h>

// Local includes.

#include "picasaweblogin.h"
#include "picasaweblogin.moc"

namespace KIPIPicasawebExportPlugin
{

PicasawebLogin::PicasawebLogin(TQWidget* parent, const TQString& header,
                               const TQString& _name, const TQString& _passwd)
              : TQDialog(parent)
{
    setSizeGripEnabled(false);

    TQVBoxLayout* vbox = new TQVBoxLayout( this, 5, 5, "vbox");

    m_headerLabel = new TQLabel(this);
    m_headerLabel->setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum,
                                             TQSizePolicy::Fixed));
    m_headerLabel->setText(header);
    vbox->addWidget( m_headerLabel );

    TQFrame* hline = new TQFrame( this, "hline" );
    hline->setFrameShape( TQFrame::HLine );
    hline->setFrameShadow( TQFrame::Sunken );
    hline->setFrameShape( TQFrame::HLine );
    vbox->addWidget( hline );

    TQGridLayout* centerLayout = new TQGridLayout(0, 1, 1, 5, 5);

    m_nameEdit = new TQLineEdit( this );
    centerLayout->addWidget(m_nameEdit, 0, 1);

    m_passwdEdit = new TQLineEdit( this );
    m_passwdEdit->setEchoMode(TQLineEdit::Password);
    centerLayout->addWidget(m_passwdEdit, 1, 1);

    TQLabel* nameLabel = new TQLabel(this);
    nameLabel->setText(i18n( "Username:" ));
    centerLayout->addWidget(nameLabel, 0, 0);

    TQLabel* passwdLabel = new TQLabel(this);
    passwdLabel->setText(i18n( "Password:" ));
    centerLayout->addWidget(passwdLabel, 1, 0);

    vbox->addLayout( centerLayout );

    TQHBoxLayout* btnLayout = new TQHBoxLayout(0, 0, 5);
    btnLayout->addItem( new TQSpacerItem( 20, 20, TQSizePolicy::Expanding,
                                         TQSizePolicy::Minimum ) );

    TQPushButton *okBtn = new TQPushButton( this );
    okBtn->setAutoDefault( true );
    okBtn->setDefault( true );
    okBtn->setText( i18n( "&OK" ) );
    btnLayout->addWidget( okBtn );

    TQPushButton *cancelBtn = new TQPushButton( this );
    cancelBtn->setText( i18n( "&Cancel" ) );
    btnLayout->addWidget( cancelBtn );

    vbox->addLayout( btnLayout );

    resize( TQSize(300, 150).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    m_nameEdit->setText(_name);
    m_passwdEdit->setText(_passwd);

    // signals and slots connections

    connect(okBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(accept()));

    connect(cancelBtn, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(reject()));
}

PicasawebLogin::~PicasawebLogin()
{
}

TQString PicasawebLogin::name() const
{
    return m_nameEdit->text();
}

TQString PicasawebLogin::password() const
{
    return m_passwdEdit->text();
}

TQString PicasawebLogin::username() const
{
    return m_nameEdit->text();
}

void PicasawebLogin::setUsername(const TQString& username)
{
    kdDebug()<<" The username passed to me is "<<username <<endl;
    m_nameEdit->setText(username);
    kdDebug()<<" The username passed to me is "<<username <<endl;
}

void PicasawebLogin::setPassword(const TQString& password)
{
    m_passwdEdit->setText(password);
}

} // namespace KIPIPicasawebExportPlugin
