/***************************************************************************
                           userhelp.cpp
----------------------------------------------------------------------------
    date                 : Aug 17 2006
    version              : 0.25
    copyright            : (C) 2005-2006 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "userhelp.h"

#include <tqfileinfo.h>    

#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <kurl.h>
#include <krun.h>
#include <kmimetype.h>
#include "kiledebug.h"

#include "userhelpdialog.h"
#include "kileconfig.h"

namespace KileHelp
{
   
UserHelp::UserHelp(KileTool::Manager *manager, KMenuBar *menubar) 
	: m_manager(manager), m_menubar(menubar), m_helpid(0), m_sepid(0)
{
	expandHelpMenu();

	if ( m_helpmenu ) 
		readConfig();
}

UserHelp::~UserHelp() 
{
	delete m_helppopup;
} 

void UserHelp::readConfig()
{
	//KILE_DEBUG() << "\tuserhelp: read config" << endl;
	TQStringList menu,files;
	
	// first read all entries
	TDEConfig *config = m_manager->config();
	config->setGroup("UserHelp");
	int entries = config->readNumEntry("entries");
	for ( int i=0; i<entries; ++i ) 
	{
		menu << config->readEntry(TQString("menu%1").arg(i));
		if ( !menu[i].isEmpty() || menu[i]=="-" )
			files <<  config->readEntry(TQString("file%1").arg(i));	
		else
			files << TQString();
	}
	
	// then update menu
	updateEntries(menu,files,false);
}

void UserHelp::writeConfig()
{
	//KILE_DEBUG() << "\tuserhelp: write config" << endl;
	int entries = m_menuentries.count();
	
	// first delete old entries
	TDEConfig *config = m_manager->config();
	config->deleteGroup("UserHelp");
	
	// then write new entries
	config->setGroup("UserHelp");
	config->writeEntry("entries",entries);
	for ( int i=0; i<entries; ++i ) 
	{
		config->writeEntry(TQString("menu%1").arg(i), m_menuentries[i]);
		if ( m_menuentries[i] != "-" )
			config->writeEntry(TQString("file%1").arg(i), m_helpfiles[i]);	
	}
}

void UserHelp::expandHelpMenu()
{ 
	m_helppopup = 0L;
	m_helpid = 0;
	m_sepid = 0;

	m_helpmenu = getHelpPopup();
	if (  m_helpmenu ) 
	{
		int helpindex = getHelpIndex(m_helpmenu);
	
		m_helppopup = new TQPopupMenu();
		if ( m_helppopup )  
		{
			m_sepid = m_helpmenu->insertSeparator(helpindex); 
			m_helpid = m_helpmenu->insertItem(i18n("User Help"),m_helppopup,-1,helpindex); 
			m_helpmenu->setItemVisible(m_helpid,false);
			m_helpmenu->setItemVisible(m_sepid,false);
		}
	}
}

// update stringlists and userhelp menu

void UserHelp::updateEntries(const TQStringList &entries, const TQStringList &files, bool save)
{
	if ( m_menuentries==entries && m_helpfiles==files)
		return;

	// save new entries	
	if ( m_helppopup )
		m_helppopup->clear();
	m_menuentries = entries;
	m_helpfiles = files;
		
	// set userhelp menu
	if ( m_menuentries.count() > 0 ) 
	{
		setupUserHelpMenu();
		m_helpmenu->setItemVisible(m_helpid,true);
		m_helpmenu->setItemVisible(m_sepid,true);
	} 
	else 
	{
		m_helpmenu->setItemVisible(m_helpid,false);
		m_helpmenu->setItemVisible(m_sepid,false);
	}	
	
	if ( save )
		writeConfig();
}

void UserHelp::setupUserHelpMenu()
{
	if ( ! m_helppopup ) return;
	
	int helpid;
	for ( uint i=0; i<m_menuentries.count(); ++i ) 
	{
		// first look, if this entry is a separator
		if ( m_menuentries[i] == "-" )  
		{
			helpid = m_helppopup->insertSeparator(-1);
		} 
		else 
		{
			// check for a http file
			bool http = ( m_helpfiles[i].find("http://",0) == 0 );
			
			// some file types have an icon
			TQFileInfo fi(m_helpfiles[i]);
			TQString ext = fi.extension(false);
			if ( ext == "htm" )
				ext = "html";
			TQString icon;
			if ( ext == "html" )
				icon = "text-html";
			else if ( ext == "dvi" )
				icon = "application-x-lyx";
			else if ( ext == "ps" )
				icon = "application-postscript";
			else if ( ext == "pdf" )
				icon = "application-pdf";
			if ( icon != "" )
			{
				TQString icon = ( http ) ? "viewhtml" : ext;
				helpid = m_helppopup->insertItem( SmallIcon(icon),m_menuentries[i],
				                                  this,TQT_SLOT(slotUserHelpActivated(int)) );
			} 
			else 
			{     
				helpid = m_helppopup->insertItem( m_menuentries[i],
				                                  this,TQT_SLOT(slotUserHelpActivated(int)) );
			}

		// send index of TQStringList as parameter, when the slot is activated 
		m_helppopup->setItemParameter(helpid,i);  
		}
	}
}

void UserHelp::enableUserHelpEntries(bool state)
{
	if ( m_helppopup )
		delete m_helppopup;

	expandHelpMenu();
	if ( m_helpmenu && m_helppopup && m_menuentries.count()>0 ) 
	{
		setupUserHelpMenu();
		m_helpmenu->setItemVisible(m_helpid,state);
		m_helpmenu->setItemVisible(m_sepid,state);
	} 
}

TQPopupMenu *UserHelp::getHelpPopup()
{ 
	int helpid = 0;
	
	for (uint i=0; i<m_menubar->count(); ++i) 
	{
		int id = m_menubar->idAt(i);
		TQString text = m_menubar->text(id);
		
		if ( text == i18n("&Help") ) 
		{
			helpid = id;
			break;
		}
	}	
	return ( helpid == 0 ) ? 0 : m_menubar->findItem(helpid)->popup();
}

int UserHelp::getHelpIndex(TQPopupMenu *popup)
{ 
	if ( popup ) 
	{
		int count = 0;
		for (uint i=0; i<popup->count(); ++i) 
		{
			int entryid = popup->idAt(i);
			TQString entry = popup->text(entryid);
	
			if ( entry.isEmpty() ) 
			{
				if ( ++count == 2 ) 
					return (i+1);
			}
		}
	}
	
	return (0);
}

void UserHelp::slotUserHelpActivated(int index)
{ 
	KILE_DEBUG() << "==slotUserHelpActivated(" << index << ")============" << endl;
	if ( ! (index>=0 && index<(int)m_helpfiles.count()) ) 
		return;
		
	// get filename of this user help entry
	TQString filename = m_helpfiles[index];

	// does the files exist?
	TQFileInfo fi(filename);
	bool http = ( filename.find("http://",0) == 0 );
	if ( !http && !fi.exists() ) 
	{
		KMessageBox::error(0,TQString(i18n("File '%1' doesn't exist.")).arg(filename));
		return;
	}
		
	// show help file
	KILE_DEBUG() << "\tshow userhelpfile (" << filename << ")" << endl;
		
	// determine, how to show the file
	TQString type;
	TQString cfg = "Embedded Viewer";
	if ( !http && KileConfig::embedded()==0 ) 
	{
		TQString ext = fi.extension(false);
		if ( ext == "dvi" ) 
			type = "ViewDVI";
		else if ( ext == "ps" )
			type = "ViewPS";
		else if ( ext == "pdf" )
			type = "ViewPDF";
		else if ( ext=="html" || ext=="htm"  ) 
			type = "ViewHTML";
	}
		
	TDEConfig *config = m_manager->config();
	if ( type!=TQString() && config->hasGroup("Tool/" + type + '/' + cfg) )
	{
		KileTool::View *tool = new KileTool::View(type, m_manager, false);
		tool->setFlags(0);
		tool->setSource(filename);
		tool->setTarget(fi.fileName());
		tool->prepareToRun();
		m_manager->run(tool,cfg);
	} 
	else 
	{
		KURL url = KURL::fromPathOrURL(filename);
		KMimeType::Ptr pMime = KMimeType::findByURL(url);
		KRun::runURL(url, pMime->name());
	}
}

void UserHelp::userHelpDialog()
{
	TQStringList userhelpmenulist, userhelpfilelist;
	
	KileDialog::UserHelpDialog *dialog = new KileDialog::UserHelpDialog();
	dialog->setParameter(m_menuentries,m_helpfiles);       
	if ( dialog->exec() ) 
	{
		//KILE_DEBUG() << "\t new userhelp entries accepted" << endl;
		dialog->getParameter(userhelpmenulist,userhelpfilelist);
		updateEntries(userhelpmenulist,userhelpfilelist);
	}
	
   delete dialog;	  
}  

}

#include "userhelp.moc"

