/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_GUILINEEDIT_H
#define TELLICO_GUILINEEDIT_H

#include <klineedit.h>

#include <tqstring.h>

class TDEAction;
class KSpell;

namespace Tellico {
  namespace GUI {

/**
 * @author Robby Stephenson
 */
class LineEdit : public KLineEdit {
Q_OBJECT
  

public:
  LineEdit(TQWidget* parent = 0, const char* name = 0);

  virtual void setText(const TQString& text);
  void setHint(const TQString& hint);

  // by default, spell check is not allowed, and no popupmenu item is created
  void setAllowSpellCheck(bool b) { m_allowSpellCheck = b; }
  // spell check may be allowed but disabled
  void setEnableSpellCheck(bool b) { m_enableSpellCheck = b; }

public slots:
  void clear();

protected:
  virtual void focusInEvent(TQFocusEvent* event);
  virtual void focusOutEvent(TQFocusEvent* event);
  virtual void drawContents(TQPainter* painter);
  virtual TQPopupMenu* createPopupMenu();

private slots:
  void slotCheckSpelling();
  void slotSpellCheckReady(KSpell* spell);
  void slotSpellCheckDone(const TQString& text);
  void spellCheckerMisspelling(const TQString& text, const TQStringList&, unsigned int pos);
  void spellCheckerCorrected(const TQString& oldText, const TQString& newText, unsigned int pos);
  void spellCheckerFinished();

private:
  TQString m_hint;
  bool m_drawHint;
  TDEAction* m_spellAction;
  bool m_allowSpellCheck;
  bool m_enableSpellCheck;
  KSpell* m_spell;
};

  } // end namespace
} // end namespace
#endif
