/***************************************************************************
                          colorrequester.cpp  -  description
                             -------------------
    copyright            : (C) 2004 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "colorrequester.h"
#include <klineedit.h>
#include <kcombobox.h>
#include <kcolordialog.h>
#include <tqtooltip.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdeaccel.h>

#include "propertysetter.h"

class colorRequester::colorRequesterPrivate{
  public:
    KLineEdit *edit;
    colorRequesterPrivate() { edit = 0L; }
    void setText( const TQString& text ) { edit->setText( text ); }
    void connectSignals( TQObject *receiver ) { connect( edit, TQT_SIGNAL( textChanged( const TQString& )),receiver, TQT_SIGNAL( textChanged( const TQString& ))); }
};

colorRequester::colorRequester(TQWidget *parent, const char* name) : miniEditor(parent,name){
  d = new colorRequesterPrivate;
  init();
}

colorRequester::~colorRequester(){
  delete myColorDialog;
  delete d;
}

void colorRequester::connectToPropertySetter(propertySetter* p){
  connect( this, TQT_SIGNAL(textChanged(const TQString&)), p, TQT_SIGNAL(valueChanged(const TQString&)));
}

void colorRequester::init()
{
     myColorDialog    = 0L;

     if ( !d->edit )
     d->edit = new KLineEdit( this, "line edit" );

     myButton = new KPushButton( this, "tdefile button");
     TQIconSet iconSet = SmallIconSet(TQString::fromLatin1("colorize"));
     TQPixmap pixMap = iconSet.pixmap( TQIconSet::Small, TQIconSet::Normal );
     myButton->setIconSet( iconSet );
     myButton->setFixedSize( pixMap.width()+8, pixMap.height()+8 );
     TQToolTip::add(myButton, i18n("Open color dialog"));

     setSpacing( KDialog::spacingHint() );

     TQWidget *widget = (TQWidget*) d->edit;
     setFocusProxy( widget );

     d->connectSignals( TQT_TQOBJECT(this) );
     connect( myButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( openColorDialog() ));
     connect( d->edit, TQT_SIGNAL( textChanged ( const TQString & ) ), this, TQT_SLOT( setInitialValue(/*const TQString&*/ ) ));

     TDEAccel *accel = new TDEAccel( this );
     accel->insert( TDEStdAccel::Open, TQT_TQOBJECT(this), TQT_SLOT( openColorDialog() ));
     accel->readSettings();
 }

void colorRequester::openColorDialog(){
 KColorDialog dlg(this,"dlg",true);
 dlg.setColor(TQColor(m_initialValue));
 if(dlg.exec()){
   TQColor myColor(dlg.color());
   d->edit->setText(myColor.name());
   emit textChanged(myColor.name());
 }
}

KLineEdit * colorRequester::lineEdit() const{
  return d->edit;
}
#include <kdebug.h>
void colorRequester::setInitialValue(/*const TQString& s*/){
  TQString temp = d->edit->text();
  temp.remove(" ");
 if( temp.contains("#") != 0){
   temp.remove("#");
   if(temp.length() == 3) {
     TQString temp2;
     temp2.append(temp[0]);
     temp2.append(temp[0]);
     temp2.append(temp[1]);
     temp2.append(temp[1]);
     temp2.append(temp[2]);
     temp2.append(temp[2]);
     temp = temp2;
   }
   bool ok;
   int r = temp.left(2).toInt( &ok, 16 );
   int g = temp.mid(2,2).toInt( &ok, 16 );
   int b = temp.right(2).toInt( &ok, 16 );
   m_initialValue.setRgb(r,g,b);
 }
 else

   if( temp.contains("rgb(") != 0){
     temp.remove("rgb(").remove(")");
     TQStringList rgbValues = TQStringList::split(",",temp);
//      bool ok;
     int r = rgbValues[0].toInt();
     int g = rgbValues[1].toInt();
     int b = rgbValues[2].toInt();
     m_initialValue.setRgb(r,g,b);
   }
   else
      m_initialValue.setNamedColor(d->edit->text());
}

#include "colorrequester.moc"
