/***************************************************************************
                    messagelog.h - Kommander dialog output
                             -------------------
    copyright          : (C) 2004      Michal Rudolf <mrudolf@kdewebdwev.org>
    
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef MESSAGELOG_H
#define MESSAGELOG_H

#include <tqtabwidget.h>

#include <tdelocale.h>

class TDEListBox;
class TDEProcess;
class TDEPopupMenu;
class TQListBoxItem;
   
class MessageLog : public TQTabWidget
{
  Q_OBJECT
  
public:  
  enum InfoType {Stdout, Stderr, All};
  MessageLog(TQWidget* parent = 0, const char* name = 0);
  ~MessageLog();
  virtual void insertItem(InfoType i, TQString text);
  virtual void clear(InfoType i = All);
  TQString content();
public slots:  
  void receivedStdout(TDEProcess *proc, char *buffer, int buflen);
  void receivedStderr(TDEProcess *proc, char *buffer, int buflen);
  void clearContent();
  void copyLine();
  void copyContent();
  void saveToFile();
  void showMenu(TQListBoxItem*, const TQPoint& l_point);
private:
  static const int m_listCount = 2;
  static TQString m_listNames[m_listCount];
  TDEListBox* m_lists[m_listCount];
  bool m_seenEOL[m_listCount];
  TDEPopupMenu* m_popupMenu;
};

#endif
