/** -*- C++ -*-
    @file adept/lister.h
    @author Peter Rockai <me@mornfall.net>
*/

#define KUBUNTU

#include <tqtooltip.h>
#include <tqmap.h>
#include <tqmutex.h>
#include <set>
#include <tqpixmap.h>

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/actor.h>
#include <apt-front/predicate/matchers.h>
#include <apt-front/predicate/combinators.h>
#include <apt-front/utils/range.h>

#include <adept/extendablelist.h>
#include <adept/listerextenderui.h>
#include <adept/actor.h>
#include <adept/listerpredicate.h>

#ifndef EPT_LISTER_H
#define EPT_LISTER_H

class KLineEdit;

namespace adept {

using namespace aptFront;
using namespace aptFront::cache;
class ListerTooltip;
class ListerItemTooltip;
class ListerItemExtender;
class ListerItem;
class Lister;

struct entityLess {
    bool operator()( entity::Entity e1, entity::Entity e2 );
};

class Lister: public ExtendableList, public Observer
{
  Q_OBJECT
  
public:
  static const int ColPackage     = 0;
#ifdef KUBUNTU
  static const int ColIcon        = 1;
  static const int ColStatus      = 2;
  static const int ColRequested   = 3;
  static const int ColDescription = 4;
  static const int ColLast        = 4;
#else
  static const int ColStatus      = 1;
  static const int ColRequested   = 2;
  static const int ColDescription = 3;
  static const int ColLast        = 3;
#endif
  static const int ColFirst       = 0;
    typedef entity::Entity Entity;
    typedef std::vector< Entity > Vector;
    typedef utils::Range< Entity > Range;
    typedef utils::VectorRange< Entity > VectorRange;
    typedef std::set< Entity > Set;
    typedef std::map< Entity, ListerItem *, entityLess > Map;
    typedef actor::Actor< entity::Package > Actor;
    typedef predicate::Predicate< Entity > Predicate;
    typedef std::map< ept::debtags::Tag, int > Cardinality;
    struct RangeProvider {
        virtual Range listerRange() = 0;
    };

    Lister (TQWidget *parent = 0, const char *name = 0);
    ~Lister();
    void setSource();
    virtual void notifyPostChange( component::Base * );
    virtual void notifyPreRebuild( component::Base * );
    virtual void notifyPostRebuild( component::Base * );
    VectorRange selection();
    VectorRange content();
    int itemCount() { return m_itemCount; }
    // void setRange( const Range &r ) { m_range = r; }
    void setRangeProvider( RangeProvider *r ) { m_rangeProvider = r; }
    void insertRange( Range );
    void setOpenToplevel( bool o ) { m_openToplevel = o; }

    bool busy() { return m_rebuildScheduled || m_inRebuild; }

signals:
    // this is adept::Lister because of braindead moc
    void actionsChanged( adept::Lister * );
    void cardinalityChanged( const Lister::Cardinality & );
    void detailsRequested( Lister::Entity );
    void rebuildStarted();
    void rebuildFinished();
    // void filterChanged( Lister::Predicate );

public slots:
    virtual void cleanRebuild();
    virtual void rebuild();
    virtual void baseAnd( ListerPredicate );
    virtual void interactiveDrop( ListerPredicate );
    virtual void interactiveAnd( ListerPredicate );
    virtual void baseSet( ListerPredicate );
    virtual void updateActions();
    virtual void scheduleRebuild();
    virtual void reallyUpdate();
protected slots:
    void contextMenu( TQListViewItem *, const TQPoint &, int );
    void contextActivated( int );
protected:
    typedef std::pair< ListerItem *, Range > InsertRangePair;
    void insertRangeInternal( InsertRangePair );
    ListerTooltip *m_tip;

    static Entity extractKey( Map::value_type );
    static bool itemSelected( Map::value_type );

    struct CreateItem {
        CreateItem( Lister *, ListerItem * );
        ~CreateItem();
        Map::value_type operator()( Entity );
        Lister *l;
        int time;
        int items;
        ListerItem *last;
        ListerItem *parent;
    };

    bool cancelRebuild();
    void rebuildInsertRange( Range );

    ListerItem *m_context;
    TQMap< TQString, TQString > m_icons;
    Map m_items;
    Vector m_all;
    RangeProvider *m_rangeProvider;
    Predicate m_baseF, m_interactiveF;
    int m_itemCount;
    bool m_rebuildScheduled:1;
    bool m_inRebuild:1;
    bool m_cancelRebuild:1;
    bool m_openToplevel:1;
    Cardinality m_cardinality;
    TQMutex m_rebuildMutex;
};

class ListerTooltip : public TQToolTip
{
public:
    ListerTooltip (TQWidget *v, Lister *p) : TQToolTip (v, 0), m_parent (p) {};
  ListerTooltip(Lister*p) : TQToolTip(p,0), m_parent(p) {};
protected:
    TQString format( const TQString &, const TQString &, bool = true );
    virtual void maybeTip (const TQPoint &p);
    Lister *m_parent;
};

class ListerItemTooltip : public TQToolTip {
public:
  ListerItemTooltip(const Lister* parent) :
    TQToolTip(parent->viewport(),0),
    m_parent(parent) {};

protected:
  const Lister* m_parent;
  virtual void maybeTip (const TQPoint& p);
};

class ListerItemExtender : public ListerItemExtenderUi,
                           public cache::Observer {
    Q_OBJECT
  
public:
    ListerItemExtender( TQWidget *parent = 0, const char * n = 0 );
    ~ListerItemExtender();
    virtual void resize( int w, int h );
    void setItem( ExtendableItem *i );
    ListerItem *item();
    entity::Entity entity() const { return m_entity; }
    void notifyPostChange( component::Base * );
    void notifyPostRebuild( component::Base * );
protected slots:
    void detailsClicked();
    void updateLogical();
signals:
    void detailsRequested( Lister::Entity );
protected:
    bool eventFilter( TQObject *o, TQEvent *e );
    void mouseReleaseEvent( TQMouseEvent *e );
    entity::Entity m_entity;
    unsigned m_leftHeight;
};

class ListerItem: public ExtendableItem
{
public:
    ListerItem(Lister *v, entity::Entity e)
        : ExtendableItem (v), m_previous( 0 ), m_entity( e )
  {};

    ListerItem(Lister *v, ListerItem *i, entity::Entity e)
        : ExtendableItem( v, i ), m_previous( i ), m_entity( e )
  {};

    ListerItem(ListerItem *p, ListerItem *i, entity::Entity e)
        : ExtendableItem( p, i ), m_previous( i ), m_entity( e )
  {};

    ListerItem(ListerItem *p, entity::Entity e)
        : ExtendableItem( p ), m_previous( 0 ), m_entity( e )
  {};

  ~ListerItem();

    virtual ItemExtender *createExtender() {
        if ( extendable() )
            return new ListerItemExtender();
        return 0;
    }

    /* virtual void updateIcon( const TQPixmap &p ) {
        if ( m_entity.is< entity::Package >()
             || m_entity.is< entity::Version >() )
            return ExtendableItem::updateIcon( p );
        setPixmap( list()->toggleColumn(), TQPixmap() );
        } */

    virtual TQString text( int column ) const;
#ifdef KUBUNTU
   virtual void setUpdatedIcon(TQPixmap& pm) { m_pixmap=pm; };
   virtual const TQPixmap* pixmap( int column ) const;
#endif
    entity::Entity entity() { return m_entity; }
    const entity::Entity entity() const { return m_entity; }
    virtual void paintCell (TQPainter *p, const TQColorGroup &cg,
                            int column, int width, int alignment);
    virtual bool less( const ExtendableItem * ) const;
    Lister *lister() {
        return dynamic_cast< Lister* >( listView() );
    }

    // beware, makes sort O(n^2lg(n^2))
    bool keepLess( const ListerItem *o ) const;
    virtual bool extendable() const {
        return ( entity().is< entity::Package >()
                 || m_entity.is< entity::Version >() );
    }

protected:
    ListerItem *m_previous;
    entity::Entity m_entity;
    TQPixmap m_pixmap;
  //  ListerItemTooltip* m_tip;
};

}

#endif /* ifndef PKGLIST_H */
