// -*- C++ -*-
#include <tdelistview.h>
#include <tqpixmap.h>
#include <tqlayout.h>
#include <tdeglobalsettings.h>
#include <vector>

#include <apt-front/utils/range.h>

#ifndef EPT_EXTENDABLELIST_H
#define EPT_EXTENDABLELIST_H
namespace adept {

using namespace aptFront;

class ExtendableItem;
class ExtendableList;
class ItemExtender;

class ExtendableList : public TDEListView {
    Q_OBJECT
    
public:
    typedef bool(*ItemCompare)( const ExtendableItem *,
                                const ExtendableItem * );
    ExtendableList( TQWidget *p = 0, const char *n = 0 );
    virtual ~ExtendableList();
    TQPixmap extendedIcon() { return m_extendedIcon; }
    TQPixmap baseIcon() { return m_baseIcon; }
    TQPixmap unextendableIcon() { return m_unextendableIcon; }
    int extenderOffset( ExtendableItem *i );
    void setExtenderHighlight( bool e ) { m_extenderHighlight = e; }
    bool extenderHighlight() { return m_extenderHighlight; }
public slots:
    void addExtender( ExtendableItem *i );
    void removeExtender( ExtendableItem *i );
    void updateExtender( ExtendableItem *i );
    void delayedUpdateExtenders();
    void updateExtenders();
    void setToggleColumn( int c ) {
        m_toggleColumn = c;
    }
    unsigned toggleColumn() { return m_toggleColumn; }
    virtual void show();
    virtual void clear();
    utils::Range< ExtendableItem * > extenders() {
        return utils::range( m_extenders.begin(), m_extenders.end() ); }
    void openToplevel();
protected slots:
    void processClick( TQListViewItem *, const TQPoint &, int );
signals:
    void extendersChanged();
protected:
    virtual void resizeEvent( TQResizeEvent * );
    virtual void showEvent( TQShowEvent * );
    virtual void keyPressEvent( TQKeyEvent * );
    std::vector< ExtendableItem * > m_extenders;
    TQPixmap m_extendedIcon;
    TQPixmap m_baseIcon;
    TQPixmap m_unextendableIcon;
    int m_toggleColumn;
    bool m_inDtor:1;
    bool m_extenderUpdateScheduled:1;
    bool m_needSort:1;
    bool m_extenderHighlight:1;
};

class ExtendableItem : public TDEListViewItem {
public:

    ExtendableItem( ExtendableList *l )
        : TDEListViewItem( l ), m_extender( 0 ) {
    }

    ExtendableItem( ExtendableList *l, ExtendableItem *prev )
        : TDEListViewItem( l, prev ), m_extender( 0 ) {
    }

    ExtendableItem( ExtendableItem *p, ExtendableItem *prev )
        : TDEListViewItem( p, prev ), m_extender( 0 ) {
    }

    ExtendableItem( ExtendableItem *p )
        : TDEListViewItem( p ), m_extender( 0 ) {
    }

    virtual void setup() {
        TDEListViewItem::setup();
        updateIcon();
    }
    void toggleExtender();

    void hideExtender() {
        if (extender())
            toggleExtender();
    }

    void showExtender() {
        if (!extender())
            toggleExtender();
    }

    ItemExtender *extender() { return m_extender; }

    static bool s_less( const ExtendableItem *a, const ExtendableItem *b );

    ExtendableList *list();

    virtual void updateIcon();
    virtual void setUpdatedIcon(TQPixmap& pm) { return; };

    virtual void paintBranches( TQPainter *, const TQColorGroup &, int, int, int );

    virtual ItemExtender *createExtender() = 0;
    virtual bool extendable() const { return false; }
    virtual bool less( const ExtendableItem * ) const = 0;
    virtual int compare( TQListViewItem *other, int col, bool ascending ) const;

    virtual ~ExtendableItem();
    virtual void setHeight( int h ) { TDEListViewItem::setHeight( h ); }
protected:
    ItemExtender *m_extender;
};

class ItemExtender : public TQWidget {
    Q_OBJECT
    
public:
    // ItemExtender( ExtendableItem *item );
    ItemExtender( TQWidget *parent, const char *n )
        : TQWidget( parent, n ), m_item( 0 )
        {}

    virtual void setItem( ExtendableItem *i ) {
        m_item = i;
    }

    virtual void polish() {
        setupColors();
    }

    ExtendableItem *item() {
        return m_item;
    }

    void resize( int w, int h ) {
        setUpdatesEnabled( false );
        TQWidget::resize( w, h );
        setUpdatesEnabled( true );
        TQWidget::resize( w, layout()->minimumSize().height() );
    }

    void resize( const TQSize &s ) {
        resize( s.width(), s.height() );
    }

public slots:
    void setupColors();
protected:
    virtual void mouseReleaseEvent( TQMouseEvent *e ) {
        e->accept();
    } // throw away mouse clicks :-)
    ExtendableItem *m_item;
};

}

#endif
