/** -*- C++ -*-
    @file adept/actor.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <tqobject.h>
#include <apt-front/cache/entity/entity.h>
#include <apt-front/actor.h>

#ifndef EPT_ACTOR_H
#define EPT_ACTOR_H

namespace adept {

using namespace aptFront;

class EntityActor : public TQObject
{
    Q_OBJECT
  
public:
    EntityActor( actor::Bound< cache::entity::Entity > a )
        : m_actor( a ), m_dead( false )
    {}
    actor::Bound< cache::entity::Entity > actor() const {
        return m_actor;
    }
public slots:
    void act() { m_actor(); }
    void destructiveAct() { 
        // in case we don't get deleted soon enough
        if ( m_dead ) return;
        m_dead = true;
        act();
        deleteLater();
    }
protected:
    actor::Bound< cache::entity::Entity > m_actor;
    bool m_dead;
};

}

#endif
