/* ============================================================
 * File   : imageinfoshared.h
 * Authors: Jesper K. Pedersen <blackie@kde.org>
 *	    
 * Date   : 2004-02-19
 * Description :
 *
 * Copyright 2004 by Jesper K. Pedersen
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */
 
#ifndef KIPI_IMAGEINFOSHARED_H
#define KIPI_IMAGEINFOSHARED_H

// TQt includes.

#include <tqstring.h>
#include <tqmap.h>
#include <tqdatetime.h>
#include <tqvariant.h>

// KDE includes.

#include <kurl.h>

// LibKIPI includes.

#include "libkipi/imageinfo.h"
#include "libkipi/libkipi_export.h"

namespace KIPI
{
    class Interface;

    class LIBKIPI_EXPORT ImageInfoShared
    {
    public:
        ImageInfoShared( KIPI::Interface* interface, const KURL& url );
        virtual ~ImageInfoShared() {}
        virtual TQString title() {return TQString();}
        virtual void setTitle( const TQString& );

        virtual TQString description() = 0;
        virtual void setDescription( const TQString& ) = 0;

        virtual TQMap<TQString,TQVariant> attributes() = 0;
        virtual void clearAttributes() = 0;
        virtual void addAttributes( const TQMap<TQString,TQVariant>& ) = 0;

        virtual KURL path();
        virtual TQDateTime time( KIPI::TimeSpec spec );
        virtual void setTime( const TQDateTime& time, TimeSpec spec = FromInfo );

        virtual bool isTimeExact();

        virtual int size();

        virtual int angle();
        virtual void setAngle( int );

        TQString toString( const TQVariant& );

        virtual void cloneData( ImageInfoShared* other );

    protected:
        KURL _url;

    private:
        ImageInfoShared() {} // Disable

        friend class ImageInfo;
        void addRef();
        void removeRef();
        int _count;
        Interface* _interface;
    };
}

#endif /* IMAGEINFOSHARED_H */

