


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvasview_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasViewImp::TQCanvasViewImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasViewImp::~TQCanvasViewImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasViewImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasViewImp *meth = new TQCanvasViewImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasViewImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_canvas_4, "canvas" },
        { Method_setCanvas_5, "setCanvas" },
        { Method_worldMatrix_6, "worldMatrix" },
        { Method_inverseWorldMatrix_7, "inverseWorldMatrix" },
        { Method_setWorldMatrix_8, "setWorldMatrix" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasViewImp *meth = new TQCanvasViewImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasView pointer from an Object.
 */
TQCanvasView *TQCanvasViewImp::toTQCanvasView( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasView *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "TQCanvasView" )
        return 0;

    return op->toNative<TQCanvasView>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasViewImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasView_1:
             return TQCanvasView_1( exec, args );
             break;

         case Constructor_QCanvasView_2:
             return TQCanvasView_2( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasViewCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasViewImp::TQCanvasView_1( KJS::ExecState *exec, const KJS::List &args )
{

    TQWidget *arg0 = extractTQWidget(exec, args, 0);


    const char *arg1 = (args.size() >= 2) ? args[1].toString(exec).ascii() : 0;

    TQt::WFlags arg2 = 0; // TODO (hack for TQCanvasView)


    // We should now create an instance of the TQCanvasView object

    TQCanvasView *ret = new TQCanvasView(

          arg0,
          arg1,
          arg2 );

    JSOpaqueProxy *prx = new JSOpaqueProxy( ret, "TQCanvasView");
    return KJS::Object( prx );
}

KJS::Object TQCanvasViewImp::TQCanvasView_2( KJS::ExecState *exec, const KJS::List &args )
{
    TQCanvas * arg0 = 0L;;

    KJS::Object obj = args[0].toObject(exec);
    JSObjectProxy *proxy = JSProxy::toObjectProxy( obj.imp() );
    if ( proxy ) arg0 = dynamic_cast<TQCanvas *>( proxy->widget() );

    TQWidget * arg1 = extractTQWidget(exec, args, 1);

    const char *arg2 = (args.size() >= 3) ? args[2].toString(exec).ascii() : 0;

    TQt::WFlags arg3 = 0; // TODO (hack for TQCanvasView)


    // We should now create an instance of the TQCanvasView object

    TQCanvasView *ret = new TQCanvasView(
          arg0,
          arg1,
          arg2,
          arg3 );

    JSOpaqueProxy *prx = new JSOpaqueProxy( ret, "TQCanvasView");
    return KJS::Object( prx );
}

KJS::Value TQCanvasViewImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasViewImp::toTQCanvasView( self );

    switch( id ) {

    case Method_canvas_4:
        return canvas_4( exec, self, args );
        break;

    case Method_setCanvas_5:
        return setCanvas_5( exec, self, args );
        break;

    case Method_worldMatrix_6:
        return worldMatrix_6( exec, self, args );
        break;

    case Method_inverseWorldMatrix_7:
        return inverseWorldMatrix_7( exec, self, args );
        break;

    case Method_setWorldMatrix_8:
        return setWorldMatrix_8( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasViewImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasViewImp::canvas_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->canvas(  );
      return KJS::Value(); // Returns 'TQCanvas *'

}

KJS::Value TQCanvasViewImp::setCanvas_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvas *
    return KJS::Value();

    TQCanvas * arg0; // Dummy

      instance->setCanvas(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasViewImp::worldMatrix_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->worldMatrix(  );
      return KJS::Value(); // Returns 'const TQWMatrix &'

}

KJS::Value TQCanvasViewImp::inverseWorldMatrix_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->inverseWorldMatrix(  );
      return KJS::Value(); // Returns 'const TQWMatrix &'

}

KJS::Value TQCanvasViewImp::setWorldMatrix_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQWMatrix arg0; // TODO (hack for qcanvasview)

      bool ret;
      ret = instance->setWorldMatrix(
       arg0 );
      return KJS::Boolean( ret );

}


} // namespace KJSEmbed
