/***************************************************************************
 *   Copyright (C) 2006 by Robert Hogan                                    *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#ifndef TDEIO_APPIMPL_H
#define TDEIO_APPIMPL_H

#include <tdeio/global.h>

#include <tqobject.h>
#include <tqstring.h>
#include <tqdir.h>

namespace TDEIO
{
  class Job;
}

class KURL;
class TDEIO_AppInfo;


class AppImpl : public TQObject
{
  Q_OBJECT

public:
  AppImpl(TDEIO_AppInfo *slave);

  void createTopLevelEntry(TDEIO::UDSEntry &entry) const;
  bool statByName(const TQString &filename, TDEIO::UDSEntry &entry);

  void listRoot();
  bool listAppContents(const TQString &name, TQValueList<TDEIO::UDSEntry> &list);

  bool parseURL(const KURL &url, TQString &name, TQString &path) const;

  int lastErrorCode() const { return m_lastErrorCode; }
  TQString lastErrorMessage() const { return m_lastErrorMessage; }

private slots:
  void createManPageEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createExeEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname,
			    const TQStringList &fullname);
  void createHomeDirEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createTDEDataDirEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createTDEConfigEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createStandardConfigEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createStandardDataDirEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createTmpDirEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);
  void createXDGDirEntry(TQValueList<TDEIO::UDSEntry> &list, const TQString &shortname);

  TQStringList getAppAddress(const TQString &name);
  TQStringList getFullLocation(const TQStringList &dirList, const TQString &name,
                           const TQDir::FilterSpec &filter, bool beginswith, bool recursive);
private:
  void createEntry(TDEIO::UDSEntry& entry, const TQString &file);

  bool m_lastListingEmpty;
	TDEIO_AppInfo *m_slave;

  /// Last error code stored in class to simplify API.
  /// Note that this means almost no method can be const.
  int m_lastErrorCode;
  TQString m_lastErrorMessage;
};

#endif
