#include "waWidget.h"
#include "waSkinModel.h"
#include "noatun/stdaction.h"
#include "waSkin.h"

WaWidget::WaWidget(int _mapping) : TQWidget(WaSkin::instance()) {
    mapping = _mapping;
    setBackgroundMode(NoBackground);
    connect (WaSkinModel::instance(), TQT_SIGNAL(skinChanged()), this, TQT_SLOT(skinChanged()));
}

WaWidget::~WaWidget() {
}

void WaWidget::paintPixmap(int pixmap_mapping) {
    if (pixmap_mapping != -1) 
        WaSkinModel::instance()->bltTo(pixmap_mapping, TQT_TQPAINTDEVICE(this), 0, 0);
     else
        WaSkinModel::instance()->paintBackgroundTo(mapping, TQT_TQPAINTDEVICE(this), 0, 0);
}

void WaWidget::paintPixmap(int pixmap_mapping, int x, int y) {
    if (pixmap_mapping != -1) 
        WaSkinModel::instance()->bltTo(pixmap_mapping, TQT_TQPAINTDEVICE(this), x, y);
     else
        WaSkinModel::instance()->paintBackgroundTo(mapping, TQT_TQPAINTDEVICE(this), x, y);
}

void WaWidget::paintPixmap(int pixmap_mapping, int argument) {
    if (pixmap_mapping != -1) 
        WaSkinModel::instance()->bltTo(pixmap_mapping, TQT_TQPAINTDEVICE(this), 0, 0, argument);
     else
        WaSkinModel::instance()->paintBackgroundTo(mapping, TQT_TQPAINTDEVICE(this), 0, 0);

}

void WaWidget::paintPixmap(int pixmap_mapping, int argument, int x, int y) {
    if (pixmap_mapping != -1) 
        WaSkinModel::instance()->bltTo(pixmap_mapping, TQT_TQPAINTDEVICE(this), x, y, argument);
    else
        WaSkinModel::instance()->paintBackgroundTo(mapping, TQT_TQPAINTDEVICE(this), x, y);
}

TQSize WaWidget::sizeHint() {
    return WaSkinModel::instance()->getMapGeometry(mapping).size();
}

void WaWidget::mousePressEvent(TQMouseEvent *e) {
    if (e->button() == Qt::RightButton)
        NoatunStdAction::ContextMenu::showContextMenu();
}

void WaWidget::skinChanged() {
    setGeometry(WaSkinModel::instance()->getMapGeometry(mapping));
    update();
}

#include <waWidget.moc>
