
#ifndef STARTER_H
#define STARTER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <kpanelapplet.h>
#include <tqmap.h>
#include <tqstring.h>
#include <tqpixmap.h>
// #include <tqpainter.h>
#include <tdeconfig.h>
#include <tdeshortcut.h>
#include "starteriface.h"
#include "mykey.h"

class DCOPClient;
class TQLabel;
class TDEPopupMenu;
class StartMenu;
class StarterConfig;

class starter : public KPanelApplet, virtual public StarterIface
{
    Q_OBJECT
    
public:
    starter(const TQString& configFile, Type t = Normal, int actions = 0,
        TQWidget *parent = 0, const char *name = 0);
    ~starter();

    virtual int widthForHeight(int height) const;
    virtual int heightForWidth(int width) const;
    virtual void preferences();
   void popupMenu();
   void showMenu();
protected:
    virtual void resizeEvent ( TQResizeEvent * );

private:
   enum State {Default, Hover, Down};
   State state;
   int _iconSize;
   bool eventFilter( TQObject *o, TQEvent *e );
   bool popupBlocked;
//    bool isDialog_;
   TQLabel *mainView;
//    TQPainter m_painter;
   DCOPClient *client;
   TDEPopupMenu *configPopup;
   StartMenu *startMenu;
   TQPixmap pixmap;
   TQPixmap hoverPixmap;
   TQPixmap downPixmap;
   StarterConfig *configDialog;
   typedef TQMap<MyKey,TQString> ShortcutList;
   ShortcutList shortcutList;
private slots:
   void addShortcut(const TDEShortcut&);
   void updateShortcutButton(const TQString&);
   void configureMenu();
   void reloadImages();
   void updateSettings();
//    void blockMenu();
   void unblockPopupDelayed();
   void unblockPopup();
   void activateShortcutButton(int);
};

#endif
