 
#ifndef MYKEY_H
#define MYKEY_H
#include <tqstring.h>

class MyKey
{
public:
   MyKey(short key, short modFlags){modFlags_ = modFlags; key_ = key;}
   MyKey(){modFlags_ = 0; key_ = 0;}
   MyKey(TQString & string)
   {
      TQString tmpString = string.left(string.findRev('+'));
      modFlags_ = 0;
      if (tmpString.contains("256")) // TQString.setNum(TQt::ShiftButton)
         modFlags_ |= TQt::ShiftButton;
      if (tmpString.contains("512")) // TQString.setNum(TQt::ControlButton)
         modFlags_ |= TQt::ControlButton;
      if (tmpString.contains("1024")) // TQString.setNum(TQt::AltButton)
         modFlags_ |= TQt::AltButton;
      tmpString = string.right(string.length() - string.findRev('+') - 1);
      key_ = tmpString.toShort();
   }
   short modFlags() const {return modFlags_;}
   short key()const {return key_;}
   bool operator==( const MyKey& myKey ) const
   {
      return (modFlags_ == myKey.modFlags() && key_ == myKey.key());
   }
   bool operator!=( const MyKey& myKey ) const
   {
      return (modFlags_ != myKey.modFlags() || key_ != myKey.key());
   }
   bool operator<( const MyKey& myKey ) const
   {
      return (!(modFlags_ < myKey.modFlags()) || key_ < myKey.key());
   }
   bool operator>( const MyKey& myKey ) const
   {
      return (!(modFlags_ > myKey.modFlags()) && key_ > myKey.key());
   }
   TQString toString() const
   {
      TQString string;
      TQString numString;
      if (modFlags_ & TQt::ShiftButton)
      {
         numString.setNum(TQt::ShiftButton);
         string += numString;
         string += '+';
      }
      if (modFlags_ & TQt::ControlButton)
      {
         numString.setNum(TQt::ControlButton);
         string += numString;
         string += '+';
      }
      if (modFlags_ & TQt::AltButton)
      {
         numString.setNum(TQt::AltButton);
         string += numString;
         string += '+';
      }
      numString.setNum(key_);
      string += numString;
      return string;
   }
private:
   short modFlags_;
   short key_;
};

#endif
