/***************************************************************************
 *   Copyright (C) 2006 by Sascha Hlusiak                                  *
 *   Spam84@gmx.de                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/



#ifndef _BUTTON_IMAGE_INCLUDED_
#define _BUTTON_IMAGE_INCLUDED_

#include <tqimage.h>
#include "crystalclient.h"

#define DEFAULT_IMAGE_SIZE 14


class ButtonImage
{
public:
	TQImage *normal,*hovered,*pressed;
	int image_width,image_height;
	int hSpace,vSpace;
	int drawMode;
	TQColor normal_color,hovered_color,pressed_color;
	
	TQImage *animated;
	TQRgb *normal_data,*hovered_data,*animated_data,*pressed_data;
	TQRgb *org_normal_data,*org_hovered_data;
	
	ButtonImage(const TQRgb *d_normal=NULL,int w=DEFAULT_IMAGE_SIZE,int h=DEFAULT_IMAGE_SIZE);
	virtual ~ButtonImage();
	
	void SetNormal(const TQRgb *d_normal,int w=DEFAULT_IMAGE_SIZE,int h=DEFAULT_IMAGE_SIZE);
	void SetHovered(const TQRgb *d_hovered=NULL);
	void SetPressed(const TQRgb *d_pressed=NULL);
	void reset();
	void finish();
	bool initialized();

	void setSpace(int hS,int vS) { hSpace=hS; vSpace=vS; }
	void setDrawMode(int dm) { drawMode=dm; }
	void setColors(TQColor n,TQColor h,TQColor p) { normal_color=n; hovered_color=h; pressed_color=p; }

	TQImage* getAnimated(float anim);
	
private:
	TQImage CreateImage(TQRgb *data,TQColor color);
	void tint(TQRgb *data,TQColor color);
};

#endif
