#!/usr/bin/env python
"""

"""
import sys
from tdecore import TDEApplication, TDECmdLineArgs
from tdeui import TDEMainWindow
from python_tqt.qt import TQVBoxLayout

## relative import -- cry me a river!
import about


class SamplerRunnerWindow(TDEMainWindow):
    def __init__(self, ctor):
        TDEMainWindow.__init__(self)
        layout = TQVBoxLayout(self)
        layout.setAutoAdd(True)
        self.widget = ctor(self)


def importItem(name):
    """ importItem(name) -> import an item from a module by dotted name

    """
    def importName(name):
        """ importName(name) -> import and return a module by name in dotted form
    
            Copied from the Python lib docs.
        """
        mod = __import__(name)
        for comp in name.split('.')[1:]:
            mod = getattr(mod, comp)
        return mod

    names = name.split('.')
    modname, itemname = names[0:-1], names[-1]
    mod = importName(str.join('.', modname))
    return getattr(mod, itemname)



if __name__ == '__main__':
    options = [('+item', 'An item in the sys.path')]
    TDECmdLineArgs.init(sys.argv, about.about)
    TDECmdLineArgs.addCmdLineOptions(options)
 
    args = TDECmdLineArgs.parsedArgs()
    if not args.count():
        args.usage()
    else:
        pathitem = args.arg(0)
        widget = importItem(pathitem)

    app = TDEApplication()
    mainWindow = SamplerRunnerWindow(widget)
    mainWindow.show()
    app.exec_loop()
